% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{add_horizon}
\alias{add_horizon}
\title{Add missing values for future dates}
\usage{
add_horizon(data, horizon, accumulate = 1L, obs_column = "confirm", by = NULL)
}
\arguments{
\item{data}{Data frame with a \code{date} column. The other columns depend on the
model that the data are to be used, e.g. \code{\link[=estimate_infections]{estimate_infections()}} or
\code{\link[=estimate_secondary]{estimate_secondary()}}. See the documentation there for the expected
format.}

\item{horizon}{Deprecated; use \code{forecast} instead to specify the predictive
horizon}

\item{accumulate}{The number of days to accumulate when generating posterior
prediction, e.g. 7 for weekly accumulated forecasts. If this is not set an
attempt will be made to detect the accumulation frequency in the data.}

\item{obs_column}{Character (default: "confirm"). If given, only the column
specified here will be used for checking missingness. This is useful if
using a data set that has multiple columns of hwich one of them
corresponds to observations that are to be processed here.}

\item{by}{Character vector. Name(s) of any additional column(s) where
data processing should be done separately for each value in the column.
This is useful when using data representing e.g. multiple geographies. If
NULL (default) no such grouping is done.}
}
\value{
A data.table with missing values for future dates
}
\description{
Add missing values for future dates
}
\keyword{internal}
