% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_epinow.R
\name{run_region}
\alias{run_region}
\title{Run epinow with Regional Processing Code}
\usage{
run_region(
  target_region,
  generation_time,
  delays,
  truncation,
  rt,
  backcalc,
  gp,
  obs,
  stan,
  horizon,
  CrIs,
  data,
  target_folder,
  target_date,
  return_output,
  output,
  complete_logger,
  verbose,
  progress_fn = NULL,
  ...
)
}
\arguments{
\item{target_region}{Character string indicating the region being evaluated}

\item{generation_time}{A call to \code{\link[=gt_opts]{gt_opts()}} (or its alias
\code{\link[=generation_time_opts]{generation_time_opts()}}) defining the generation time distribution used.
For backwards compatibility a list of summary parameters can also be passed.}

\item{delays}{A call to \code{\link[=delay_opts]{delay_opts()}} defining delay distributions and
options. See the documentation of \code{\link[=delay_opts]{delay_opts()}} and the examples below for
details.}

\item{truncation}{A call to \code{\link[=trunc_opts]{trunc_opts()}} defining the truncation of
the observed data. Defaults to \code{\link[=trunc_opts]{trunc_opts()}}, i.e. no truncation.  See the
\code{\link[=estimate_truncation]{estimate_truncation()}} help file for an approach to estimating this from
data where the \code{dist} list element returned by \code{\link[=estimate_truncation]{estimate_truncation()}} is
used as the \code{truncation} argument here, thereby propagating the uncertainty
in the estimate.}

\item{rt}{A list of options as generated by \code{\link[=rt_opts]{rt_opts()}} defining Rt
estimation. Defaults to \code{\link[=rt_opts]{rt_opts()}}. To generate new infections using
the non-mechanistic model instead of the renewal equation model, use
\code{rt = NULL}. The non-mechanistic model internally uses the setting
\code{rt = rt_opts(use_rt = FALSE, future = "project", gp_on = "R0")}.}

\item{backcalc}{A list of options as generated by \code{\link[=backcalc_opts]{backcalc_opts()}} to
define the back calculation. Defaults to \code{\link[=backcalc_opts]{backcalc_opts()}}.}

\item{gp}{A list of options as generated by \code{\link[=gp_opts]{gp_opts()}} to define the
Gaussian process. Defaults to \code{\link[=gp_opts]{gp_opts()}}. Set to \code{NULL} to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{\link[=obs_opts]{obs_opts()}} defining the
observation model. Defaults to \code{\link[=obs_opts]{obs_opts()}}.}

\item{stan}{A list of stan options as generated by \code{\link[=stan_opts]{stan_opts()}}. Defaults
to \code{\link[=stan_opts]{stan_opts()}}. Can be used to override \code{data}, \code{init}, and \code{verbose}
settings if desired.}

\item{horizon}{Numeric, defaults to 7. Number of days into the future to
forecast.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{data}{A \verb{<data.frame>} of confirmed cases (confirm) by date
(date), and region (\code{region}).}

\item{target_folder}{Character string specifying where to save results (will
create if not present).}

\item{target_date}{Date, defaults to maximum found in the data if not
specified.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned,
this automatically updates to TRUE if no directory for saving is specified.}

\item{output}{A character vector of optional output to return. Supported
options are the individual regional estimates ("regions"),  samples
("samples"), plots ("plots"), copying the individual region dated folder into
a latest folder (if \code{target_folder} is not null, set using "latest"), the
stan fit of the underlying model ("fit"), and an overall summary across
regions ("summary"). The default is to return samples and plots alongside
summarised estimates and summary statistics. If \code{target_folder} is not NULL
then the default is also to copy all results into a latest folder.}

\item{complete_logger}{Character string indicating the logger to output
the completion of estimation to.}

\item{verbose}{Logical defaults to FALSE. Outputs verbose progress messages
to the console from \code{\link[=epinow]{epinow()}}.}

\item{progress_fn}{Function as returned by \code{\link[progressr:progressor]{progressr::progressor()}}. Allows
the use of a  progress bar. If NULL (default), no progress bar is used.}

\item{...}{Pass additional arguments to \code{\link[=epinow]{epinow()}}. See the documentation for
\code{\link[=epinow]{epinow()}} for details.}
}
\value{
A list of processed output as produced by \code{\link[=process_region]{process_region()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Internal function that handles calling \code{\link[=epinow]{epinow()}}. Future work will extend
this function to better handle stan logs and allow the user to modify
settings between regions.
}
\seealso{
\code{\link[=regional_epinow]{regional_epinow()}}
}
