% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{collapse}
\alias{collapse}
\title{Collapse nonparametric distributions in a <dist_spec>}
\usage{
collapse(x)
}
\arguments{
\item{x}{A \verb{<dist_spec>}}
}
\value{
A \verb{<dist_spec>} where consecutive nonparametric distributions
have been convolved
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This convolves any consecutive nonparametric distributions contained
in the <dist_spec>.
}
\examples{
# A fixed gamma distribution with mean 5 and sd 1.
dist1 <- Gamma(mean = 5, sd = 1, max = 20)

# An uncertain lognormal distribution with mean 3 and sd 2
dist2 <- LogNormal(mean = 3, sd = 2, max = 20)

# The maxf the sum of two distributions
collapse(discretise(dist1 + dist2))
}
