% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_stan_data}
\alias{create_stan_data}
\title{Create Stan Data Required for estimate_infections}
\usage{
create_stan_data(
  reported_cases,
  generation_time,
  rt,
  gp,
  obs,
  delays,
  horizon,
  backcalc,
  shifted_cases,
  truncation
)
}
\arguments{
\item{reported_cases}{A data frame of confirmed cases (confirm) by date
(date). confirm must be integer and date must be in date format.}

\item{generation_time}{A call to \code{generation_time_opts()} defining the
generation time distribution used. For backwards compatibility a list of
summary parameters can also be passed.}

\item{rt}{A list of options as generated by \code{rt_opts()} defining Rt estimation.
Defaults to \code{rt_opts()}. Set to \code{NULL} to switch to using  back calculation
rather than generating infections using Rt.}

\item{gp}{A list of options as generated by \code{gp_opts()} to define the
Gaussian process. Defaults to \code{gp_opts()}.Set to NULL to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{obs_opts()} defining the
observation model. Defaults to \code{obs_opts()}.}

\item{delays}{A call to \code{delay_opts()} defining delay distributions and
options. See the documentation of \code{delay_opts()} and the examples below for
details.}

\item{horizon}{Numeric, forecast horizon.}

\item{backcalc}{A list of options as generated by \code{backcalc_opts()} to define the
back calculation. Defaults to \code{backcalc_opts()}.}

\item{shifted_cases}{A dataframe of delay shifted cases}

\item{truncation}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} A list of options as
generated by \code{trunc_opts()} defining the truncation of observed data.
Defaults to \code{trunc_opts()}. See \code{estimate_truncation()} for an approach to
estimating truncation from data.}
}
\value{
A list of stan data
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Takes the output of \code{stan_opts()} and converts it into a list understood by
\code{stan}. Internally calls the other \code{create_} family of functions to
construct a single list for input into stan with all data required present.
}
\author{
Sam Abbott

Sebastian Funk
}
