% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_epinow.R
\name{regional_epinow}
\alias{regional_epinow}
\title{Real-time Rt Estimation, Forecasting and Reporting by Region}
\usage{
regional_epinow(
  reported_cases,
  generation_time,
  delays = delay_opts(),
  truncation = trunc_opts(),
  rt = rt_opts(),
  backcalc = backcalc_opts(),
  gp = gp_opts(),
  obs = obs_opts(),
  stan = stan_opts(),
  horizon = 7,
  CrIs = c(0.2, 0.5, 0.9),
  target_folder = NULL,
  target_date,
  non_zero_points = 2,
  output = c("regions", "summary", "samples", "plots", "latest"),
  return_output = FALSE,
  summary_args = list(),
  verbose = FALSE,
  logs = tempdir(),
  ...
)
}
\arguments{
\item{reported_cases}{A data frame of confirmed cases (confirm) by date (date), and region (\code{region}).}

\item{generation_time}{A list containing the mean, standard deviation of the mean (mean_sd),
standard deviation (sd), standard deviation of the standard deviation and the maximum allowed value for the
generation time (assuming a gamma distribution).}

\item{delays}{A call to \code{delay_opts} defining delay distributions and options. See the documentation of \code{delay_opts}
and the examples below for details.}

\item{truncation}{\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}} A list of options as generated by \code{trunc_opts()}
defining the truncation of observed data. Defaults to \code{trunc_opts()}. See \code{estimate_truncation()}
for an approach to estimating truncation from data.}

\item{rt}{A list of options as generated by \code{rt_opts()} defining Rt estimation.
Defaults to \code{rt_opts()}. Set to \code{NULL} to switch to using  back calculation
rather than generating infections using Rt.}

\item{backcalc}{A list of options as generated by \code{backcalc_opts()} to define the
back calculation. Defaults to \code{backcalc_opts()}.}

\item{gp}{A list of options as generated by \code{gp_opts()} to define the
Gaussian process. Defaults to \code{gp_opts()}.Set to NULL to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{obs_opts()} defining the
observation model. Defaults to \code{obs_opts()}.}

\item{stan}{A list of stan options as generated by \code{stan_opts()}. Defaults to \code{stan_opts()}. Can be used to override
\code{data}, \code{init}, and \code{verbose} settings if desired.}

\item{horizon}{Numeric, defaults to 7. Number of days into the future to forecast.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{target_date}{Date, defaults to maximum found in the data if not specified.}

\item{non_zero_points}{Numeric, the minimum number of time points with non-zero cases in a region required for
that region to be evaluated. Defaults to 7.}

\item{output}{A character vector of optional output to return. Supported options are the individual regional estimates
("regions"),  samples ("samples"), plots ("plots"), copying the individual region dated folder into
a latest folder (if \code{target_folder} is not null, set using "latest"), the stan fit of the underlying model ("fit"), and an
overall summary across regions ("summary"). The default is to return samples and plots alongside summarised estimates and
summary statistics. If \code{target_folder} is not NULL then the default is also to copy all results into a latest folder.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned, this automatically updates to TRUE
if no directory for saving is specified.}

\item{summary_args}{A list of arguments passed to \code{regional_summary}. See the \code{regional_summary} documentation for details.}

\item{verbose}{Logical defaults to FALSE. Outputs verbose progress messages to the console from \code{epinow}.}

\item{logs}{Character path indicating the target folder in which to store log
information. Defaults to the temporary directory if not specified. Default logging
can be disabled if \code{logs} is set to NULL. If specifying a custom logging setup then
the code for \code{setup_default_logging} and the \code{setup_logging} function are a sensible
place to start.}

\item{...}{Pass additional arguments to \code{epinow}. See the documentation for \code{epinow} for details.}
}
\value{
A list of output stratified at the top level into regional output and across region output summary output
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
Efficiently runs \code{epinow()} across multiple regions in an efficient manner and conducts basic data checks and
cleaning such as removing regions with fewer than \code{non_zero_points} as these are unlikely to produce reasonable
results whilst consuming significant resources. See the documentation for \code{epinow} for further information.

By default all arguments supporting input from \verb{_opts} functions are shared across regions (including delays,
truncation, Rt settings, stan settings, and gaussian process settings). Region specific settings are supported
by passing a named list of \verb{_opts} calls (with an entry per region) to the relevant argument. A helper function
(\code{opts_list}) is available to facilitate building this list.

Regions can be estimated in parallel using the \code{{future}} package (see \code{setup_future}). The progress of producing
estimates across multiple regions is tracked using the \code{progressr} package. Modify this behaviour using
progressr::handlers and enable it in batch by setting \code{R_PROGRESSR_ENABLE=TRUE} as an environment variable.
}
\examples{
 \donttest{
#set number of cores to use
options(mc.cores = ifelse(interactive(), 4, 1))

# construct example distributions
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- list(mean = convert_to_logmean(3,1),
                        mean_sd = 0.1,
                        sd = convert_to_logsd(3,1),
                        sd_sd = 0.1, max = 15)
                        
# uses example case vector
cases <- example_confirmed[1:60]
cases <- data.table::rbindlist(list(
  data.table::copy(cases)[, region := "testland"],
  cases[, region := "realland"]))
                
# run epinow across multiple regions and generate summaries
# samples and warmup have been reduced for this example
def <- regional_epinow(reported_cases = cases, 
                       generation_time = generation_time,
                       delays = delay_opts(incubation_period, reporting_delay),
                       rt = rt_opts(prior = list(mean = 2, sd = 0.2)),
                       stan = stan_opts(samples = 100, warmup = 200),
                       verbose = interactive())
                       
# apply a different rt method per region
# (here a gaussian process and a weekly random walk)
gp <- opts_list(gp_opts(), cases)
gp <- update_list(gp, list(realland = NULL))
rt <- opts_list(rt_opts(), cases, realland = rt_opts(rw = 7))
region_rt <- regional_epinow(reported_cases = cases, 
                             generation_time = generation_time,
                             delays = delay_opts(incubation_period, reporting_delay),
                             rt = rt, gp = gp,
                             stan = stan_opts(samples = 100, warmup = 200),
                             verbose = interactive())
}
}
\seealso{
epinow estimate_infections forecast_infections setup_future regional_summary
}
