% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimIncub.R
\name{estimIncub}
\alias{estimIncub}
\title{Estimation of the incubation density based on coarse data}
\usage{
estimIncub(x, K = 10, niter = 1000, tmax = max(x), tgridlen = 500, verbose = FALSE)
}
\arguments{
\item{x}{A data frame with the lower and upper bound of incubation interval.}

\item{K}{Number of B-splines in the basis.}

\item{niter}{The number of MCMC samples.}

\item{tmax}{The upper bound for the B-spline basis. Default is the largest
data point in \code{x}.}

\item{tgridlen}{The number of grid points on which to evaluate the density.}

\item{verbose}{Should a message be printed? Default is FALSE.}
}
\value{
A list of class \code{incubestim} containing summary values for
 the estimated incubation density.
}
\description{
This function computes an estimate of the incubation density based on
coarse data constructed from symptom onset times and exposure windows. It
uses the Laplacian-P-splines methodology with a Langevinized Gibbs algorithm
to sample from the posterior distribution.
}
\examples{
set.seed(123)
simdat <- incubsim(n = 30, tmax = 20) # Simulate incubation data
data <- simdat$Dobsincub              # Incubation bounds
incubfit <- estimIncub(x = data, niter = 500, tmax = 20, verbose = TRUE)

}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
