% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngram.R
\name{ngram}
\alias{ngram}
\title{Compute n-Gram Frequencies Vector}
\usage{
ngram(prot, n = 1)
}
\arguments{
\item{prot}{a character string corresponding to the primary structure of the protein.}

\item{n}{a positive integer between 1 and 4.}
}
\value{
A dataframe with two columns, the first one given the peptides and the second one the corresponding absolute frequency.
}
\description{
Computes the n-gram frequencies vector for a given protein.
}
\details{
The one letter code for amino acids is used (capital).
}
\examples{
ngram(bovids$Bos_taurus[1], n = 3)
}
\references{
Stuart et al. Bioinformatics 2002; 18:100-108.
}
\seealso{
ngraMatrix(), svdgram()
}
