% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfidenceIntervalCalibration.R
\name{convertNullToErrorModel}
\alias{convertNullToErrorModel}
\title{Convert empirical null distribution to systematic error model}
\usage{
convertNullToErrorModel(null, meanSlope = 1, sdSlope = 0)
}
\arguments{
\item{null}{The empirical null distribution fitted using either the \code{\link{fitNull}}
or the \code{\link{fitMcmcNull}} function.}

\item{meanSlope}{The slope for the mean of the error distribution. A slope of 1 means the error
is the same for different values of the true relative risk.}

\item{sdSlope}{The slope for the log of the standard deviation of the error distribution. A slope
of 0 means the standard deviation is the same for different values of the true 
relative risk.}
}
\value{
An object of type \code{systematicErrorModel}.
}
\description{
This function converts an empirical null distribution, fitted using estimates only for negative controls,
into a systematic error distribution that can be used to calibrate confidence intervals in addition to
p-values. 

Whereas the \code{\link{fitSystematicErrorModel}} uses positive controls to determine how the error 
distribution changes with true effect size, this function requires the user to make an assumption. The
default assumption, \code{meanSlope = 1} and \code{sdSlope = 0}, specify a belief that the error 
distribution is the same for all true effect sizes. In many cases this assumption is likely to be correct,
however, if an estimation method is biased towards the null this assumption will be violated, causing the
calibrated confidence intervals to have lower than nominal coverage.
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
null <- fitNull(negatives$logRr, negatives$seLogRr)
model <- convertNullToErrorModel(null)
positive <- sccs[sccs$groundTruth == 1, ]
calibrateConfidenceInterval(positive$logRr, positive$seLogRr, model)

}
