% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNHES.R
\name{readNHES}
\alias{readNHES}
\title{Connect to NHES Survey Data}
\usage{
readNHES(savFiles, surveyCode = "auto", forceReread = FALSE, verbose = TRUE)
}
\arguments{
\item{savFiles}{a character vector to the full file path(s) to the NHES
extracted SPSS (*.sav) data files.}

\item{surveyCode}{a character vector of the \code{surveyCode} to identify the year and survey type of the passed \code{savFiles} data file(s).
The default value is set to \code{auto} which attempts to automatically identify the survey/year based on the file attributes.
Occasionally, the \code{auto} lookup may be unable to determine the \code{surveyCode} and must be explicitly set by the user.
The lengths of the \code{savFiles} vector and \code{surveyCode} vector must match, unless \code{surveyCode} is set to \code{auto}.
To view the \code{surveyCodes} available, use the \code{getNHES_SurveyInfo}, or \code{viewNHES_SurveyCodes} function to view the codes.}

\item{forceReread}{a logical value to force a rereading of all processed data.
The default value of \code{FALSE} speeds up the
\code{readNHES} function by using existing read-in data if already processed.}

\item{verbose}{a logical value that defaults to \code{TRUE} for verbose console output that indicates progress information.
If \code{verbose = FALSE}, no information will be printed.}
}
\value{
an \code{edsurvey.data.frame} if only one NHES file is specified for the \code{savFiles} argument,
or an \code{edsurvey.data.frame.list} if multiple files are passed to the \code{savFiles} argument
}
\description{
Opens a connection to a National Household Education Survey (NHES) data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped public-use files downloaded from the NCES Online Codebook (\url{https://nces.ed.gov/OnlineCodebook}) in SPSS (*.sav) format.
Other sources of NHES data, such as restricted-use files or other websites, may require additional conversion steps to generate the required SPSS data format
and/or explicitly setting the \code{surveyCode} parameter.
}
\examples{
\dontrun{
rootPath <- "~/"

#get instructions for obtaining NHES data 
downloadNHES()

#get SPSS *.sav file paths of all NHES files for 2012 and 2016
filesToImport <- list.files(path = file.path(rootPath, "NHES", c(2012, 2016)), 
                            pattern="\\\\.sav$", 
                            full.names = TRUE, 
                            recursive = TRUE)

#import all files to edsurvey.data.frame.list object
esdfList <- readNHES(savFiles = filesToImport, surveyCode = "auto", 
                     forceReread = FALSE, verbose = TRUE)

viewNHES_SurveyCodes() #view NHES survey codes in console

#get the full file path to the 2016 ATES NHES survey
path_ates2016 <- list.files(path = file.path(rootPath, "NHES", "2016"), 
                            pattern=".*ates.*[.]sav$", full.names = TRUE)

#explicitly setting the surveyCode parameter (if required)
esdf <- readNHES(savFiles = path_ates2016, surveyCode = "ATES_2016", 
                 forceReread = FALSE, verbose = TRUE)

#search for variables in the edsurvey.data.frame
searchSDF("sex", esdf)
}
}
\seealso{
\code{\link{downloadNHES}}, \code{\link{getNHES_SurveyInfo}}, and \code{\link{viewNHES_SurveyCodes}}
}
\author{
Tom Fink
}
