% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergev.R
\name{mergev}
\alias{mergev}
\title{mergev}
\usage{
mergev(
  x,
  y,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  all.x = NULL,
  all.y = NULL,
  all = FALSE,
  order = c("sort", "unsorted", "x", "y"),
  fast = FALSE,
  merge.type.colname = "merge.type",
  return.list = FALSE,
  verbose = TRUE,
  showWarnings = TRUE,
  ...
)
}
\arguments{
\item{x}{first data.frame to merge, same as in \code{\link[base]{merge}}.}

\item{y}{second data.frame to merge, same as in \code{\link[base]{merge}}.}

\item{by}{character vector of column names to merge by. When \code{by} is used, the column names
must be the same in \code{x} and \code{y}. Silently overrides \code{by.x}
and \code{by.y}}

\item{by.x}{character vector of column names on \code{x} to merge by. The resulting file will have 
these names.}

\item{by.y}{character vector of column names on \code{y} to merge by.}

\item{all.x}{logical value indicating if unmerged rows from \code{x} should be included in the output.}

\item{all.y}{logical value indicating if unmerged rows from \code{y} should be included in the output.}

\item{all}{logical value indicating if unmerged rows from \code{x} and \code{y} should be included in the output.
Silently overrides \code{all.x} and \code{all.y}.}

\item{order}{character string from "sort", "unsorted", "x", and "y".
Specifies the order of the output. Setting this to "sort"
gives the same result as \code{\link[base]{merge}} with sort=TRUE.
unsorted gives the same result as sort=FALSE. "x" and "y" sort by the incoming
sort order of \code{x} and \code{y}, respectively.}

\item{fast}{logical value indicating if \code{data.table} should be used to do the merge.}

\item{merge.type.colname}{character indicating the column name of the resulting merge type column.
See description.}

\item{return.list}{logical value indicating if the merged data.frame and verbose output should be
returned as elements of a list. Defaults to FALSE where the function
simply returns a data.frame.}

\item{verbose}{logical value indicating if output should be reported. Defaults to TRUE. Useful for testing.}

\item{showWarnings}{logical value to output warning messages (TRUE) or suppress (FALSE).  Defaults to TRUE.}

\item{...}{additional parameters passed to merge.}
}
\value{
depends on the value of \code{return.list}.

When \code{return.list} is \code{FALSE}, returns a \code{data.frame}. 

When \code{return.list} is \code{TRUE}, returns a list with two elements. The first is the same \code{data.frame} result. The second
is a list with the values that were printed out. Elements include merge.type with two elements, each "one" or "many" indicating the
merge type for \code{x} and \code{y}, respectively; inBoth, the list of column names in both merged data.frames; and merge.matrix
the matrix printed out by this function.
}
\description{
More verbose merge function
}
\details{
This is a wrapper for the base package merge function that prints out verbose information 
about the merge, including the merge type (one/many to one/many), the overlapping column
names that will have suffixes applied, the number of rows and the number of unique
keys that are in each dataset and in the resulting dataset. 

Also gives more detailed errors when, e.g. the columns named in the \code{by} argument are
not on the \code{x} or \code{y} data.frames.
}
