% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed.sdf.R
\name{mixed.sdf}
\alias{mixed.sdf}
\title{EdSurvey Mixed-Effects Model}
\usage{
mixed.sdf(
  formula,
  data,
  weightVars = NULL,
  weightTransformation = TRUE,
  recode = NULL,
  defaultConditions = TRUE,
  tolerance = 0.01,
  nQuad = NULL,
  verbose = 0,
  family = NULL,
  centerGroup = NULL,
  centerGrand = NULL,
  fast = FALSE,
  ...
)
}
\arguments{
\item{formula}{a \ifelse{latex}{\code{formula}}{\code{\link[stats]{formula}}}
for the multilevel regression or mixed model. See Examples and the vignette titled 
\emph{\href{https://www.air.org/sites/default/files/EdSurvey-Mixed_Models.pdf}{Methods Used for Estimating Mixed-Effects Models in EdSurvey}}
for more details on how to specify a mixed model. If \emph{y} is
left blank, the default subject scale or subscale variable
will be used. (You can find the default using
\code{\link{showPlausibleValues}}.) If \emph{y} is a variable
for a subject scale or subscale (one of the names shown by
\code{\link{showPlausibleValues}}), then that subject scale
or subscale is used.}

\item{data}{an \code{edsurvey.data.frame} or a \code{light.edsurvey.data.frame}}

\item{weightVars}{character vector indicating weight variables for
corresponding levels to use. The \code{weightVar} must be
the weights for the \code{edsurvey.data.frame}. The weight variables
must be in the order of level (from lowest to highest level).}

\item{weightTransformation}{a logical value to indicate whether the function
should standardize weights before using it in the
multilevel model. If set to \code{TRUE}, the
function will look up standard weight
transformation methods often used for a specific
survey. Weight transformation can be found in the vignette titled 
\emph{\href{https://www.air.org/sites/default/files/EdSurvey-Mixed_Models.pdf}{Methods Used for Estimating Mixed-Effects Models in EdSurvey}}.
If set to \code{FALSE} or if the survey of the specified \code{data} does
not have a standard weight transformation method,
raw weights will be used.}

\item{recode}{a list of lists to recode variables. Defaults to \code{NULL}. Can be set as
\code{recode=}\code{list(}\code{var1} \code{=} \code{list(}\code{from=} \code{c("a",} \code{"b",} \code{"c"),} \code{to=} \code{"d"))}. 
See Examples in \ifelse{latex}{\code{lm.sdf}}{\code{\link{lm.sdf}}}.}

\item{defaultConditions}{a logical value. When set to the default value of
\code{TRUE}, uses the default conditions stored in
an \code{edsurvey.data.frame} to subset the data.
Use \code{print} on an \code{edsurvey.data.frame}
to see the default conditions.}

\item{tolerance}{depreciated, no effect}

\item{nQuad}{depreciated, no effect}

\item{verbose}{an integer; when set to \code{1}, it will print out
the brief progress of the function \code{mix.sdf}.
Users can use these traced messages for further diagnosis.
When set to \code{2}, it will print
out the detailed progress, including temporary estimates
   during the optimization. Defaults to \code{0}, which 
   will run the function without output.}

\item{family}{this argument is depreciated; please use the \code{WeMix}
package's \code{mix} function directly for binomial models.}

\item{centerGroup}{a list in which the name of each element is the name of the aggregation level, 
and the element is a formula of variable names to be group mean centered. For example, to group mean center
 gender and age within the group student: \code{list("student"= ~gender+age)}. Defaults to \code{NULL}, which means 
 predictors are not adjusted by group centering. See Examples in the \code{WeMix} function \ifelse{latex}{\code{mix}}{\code{\link[WeMix]{mix}}}.}

\item{centerGrand}{a formula of variable names to be grand mean centered. For example, to center the 
variable education by overall mean of education: \code{~education}. Defaults to \code{NULL}, which means predictors
are not adjusted by grand centering.}

\item{fast}{depreciated, no effect}

\item{...}{other potential arguments to be used in \ifelse{latex}{\code{mix}}{\code{\link[WeMix]{mix}}}}
}
\value{
A \code{mixedSdfResults} object with the following elements:
   \item{call}{the original call used in \code{mixed.sdf} }
   \item{formula}{the formula used to fit the model}
   \item{coef}{a vector of coefficient estimates}
   \item{se}{a vector with the standard error estimates of the coefficients and the standard error of the variance components}
   \item{vars}{estimated variance components of the model}
   \item{levels}{the number of levels in the model}
   \item{ICC}{the intraclass correlation coefficient of the model}
   \item{npv}{the number of plausible values}
   \item{ngroups}{a \code{data.frame} that includes the number of observations for each group}
   \item{n0}{the number of observations in the original data}
   \item{nused}{the number of observations used in the analysis}
If the formula does not involve plausible values, the function will return the following additional elements:
   \item{lnlf}{the likelihood function } 
   \item{lnl}{the log-likelihood of the model }
If the formula involves plausible values, the function will return the following additional elements:
   \item{Vimp}{the estimated variance from uncertainty in the scores}
   \item{Vjrr}{the estimated variance from sampling}
}
\description{
Fits a linear weighted mixed-effects model.
}
\details{
This function uses the \code{mix} call in the \code{WeMix} package to fit mixed models.
When the outcome does not have plausible values, the variance estimator directly from
the \code{mix} function is used; these account for covariance at the top level
of the model specified by the user.

When the outcome has plausible values, the coefficients are estimated in the same
way as in \code{lm.sdf}, that is, averaged across the plausible values.
In addition, the variance of the coefficients is estimated
as the sum of the variance estimate from the \code{mix} function and the
imputation variance. The formula for the imputation variance is, again, the same
as for \code{lm.sdf},
with the same estimators as in the vignette titled
\href{https://www.air.org/sites/default/files/EdSurvey-Statistics.pdf}{\emph{Statistical Methods Used in EdSurvey}}.
In the section
\dQuote{Estimation of Standard Errors of Weighted Means When Plausible Values Are Present, Using the Jackknife Method}
in the formula for \eqn{V_{imp}}, the variance
and estimates of the variance components are estimated with the same formulas as
the regression coefficients.
}
\examples{
\dontrun{
# save TIMSS 2015 data to ~/TIMSS/2015
downloadTIMSS(root="~/", years=2015)
fin <- readTIMSS("~/TIMSS/2015", countries="fin", gradeLvl=4)
# uses all plausible values
mix1 <- mixed.sdf(mmat ~ itsex + (1|idschool), data = fin,
                  weightVar=c("totwgt","schwgt"), weightTransformation=FALSE)
summary(mix1)
# uses only one plausible value
mix2 <- mixed.sdf(asmmat01 ~ itsex + (1|idschool), data = fin,
                  weightVar=c("totwgt","schwgt"), weightTransformation=FALSE)
summary(mix2)
}
}
\references{
Rabe-Hesketh, S., & Skrondal, A. (2006). Multilevel modelling of complex
survey data. \emph{Journal of the Royal Statistical Society: Series A
(Statistics in Society), 169}(4), 805--827.
}
\seealso{
\ifelse{latex}{WeMix \code{mix} function}{\code{\link[WeMix]{mix}}} and \code{\link{lm.sdf}}
}
\author{
Paul Bailey, Trang Nguyen, and Claire Kelley
}
