% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPIAAC.R
\name{readPIAAC}
\alias{readPIAAC}
\title{Connect to PIAAC Data}
\usage{
readPIAAC(
  path,
  countries,
  forceReread = FALSE,
  verbose = TRUE,
  usaOption = "12_14"
)
}
\arguments{
\item{path}{a character value to the full directory path to the PIAAC .csv
files and Microsoft Excel codebook}

\item{countries}{a character vector of the country/countries to include 
using the three-digit ISO country code. A list of country
codes can be found in the PIAAC codebook or
\url{https://en.wikipedia.org/wiki/ISO_3166-1#Current_codes}.
If files are downloaded using \code{\link{downloadPIAAC}},
a country dictionary text file can be
found in the filepath. You can use \code{*} to indicate
all countries available. For the \code{usa}, the year must 
be specified using: \code{usa12_14} or  \code{usa17}.}

\item{forceReread}{a logical value to force rereading of all processed data.
Defaults to \code{FALSE}.
Setting \code{forceReread} to be \code{TRUE} will cause
PIAAC data to be reread and increase the processing time.}

\item{verbose}{a logical value that will determine if you want verbose
output while the function is running to indicate the progress.
Defaults to \code{TRUE}.}

\item{usaOption}{a character value of \code{12_14} or \code{17} that specifies 
what year of the USA survey should be used when loading all countries by 
using \code{*} in the \code{countries} argument. This will only make a difference 
when loading all countries. Defaults to \code{12_14}.}
}
\value{
an \code{edsurvey.data.frame} for a single specified country or 
an \code{edsurvey.data.frame.list} if multiple countries specified
}
\description{
Opens a connection to a PIAAC data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the unzipped .csv files downloaded from the PIAAC dataset using
the OECD repository (\url{http://www.oecd.org/skills/piaac/}). Users can use
\code{\link{downloadPIAAC}} to download all required files automatically.
}
\examples{
\dontrun{
# the following call returns an edsurvey.data.frame to PIAAC for Canada
can <- readPIAAC("~/PIAAC/Cycle 1/", countries = "can")

# extract a data.frame with a few variables
gg <- getData(can, c("c_d05","ageg10lfs"))  
head(gg)

# conduct an analysis on the edsurvey.data.frame
edsurveyTable(~ c_d05 + ageg10lfs, data = can)
}
}
\references{
Organisation for Economic Co-operation and Development. (2016). \emph{Technical report of the survey of adult skills (PIAAC)} (2nd ed.). Paris, France: Author. Retrieved from \emph{\url{http://www.oecd.org/skills/piaac/PIAAC_Technical_Report_2nd_Edition_Full_Report.pdf}}
}
\seealso{
\code{\link{getData}} and \code{\link{downloadPIAAC}}
}
\author{
Trang Nguyen
}
