% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBB_2001.R
\name{readBB_2001}
\alias{readBB_2001}
\title{Connect to B&B 2000--2001 Data}
\usage{
readBB_2001(
  b01DER_Filepath,
  b01WT_FilePath,
  masterTxtFilepath,
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{b01DER_Filepath}{a character value to the main study-derived analytical data file (\code{B01DER.dat}).  Located within the ECBW/Data Folder.}

\item{b01WT_FilePath}{a character value to the study weight data file (\code{B01WT.dat}). Located within the \code{ECBW/Data} Folder.}

\item{masterTxtFilepath}{a character value of the master format file (\code{master.txt}) that contains the metadata 
for the \code{b01DER_Filepath} and \code{b01WT_FilePath}.  Located in the \code{ECBW} folder.}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output while the \code{readBB_2001} function is running to indicate processing progress.
The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for the B&B 2000--2001 longitudinal dataset.
}
\description{
Opens a connection to a Baccalaureate & Beyond 2000--2001 data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads the \code{masterTxtFilepath} file to parse the \code{b01DER_Filepath} and \code{b01WT_FilePath} files to an \code{edsurvey.data.frame}.
         This function creates two cached data files will be saved in the same directory and filename as the \code{b01DER_Filepath} file for the B&B 2000--2001 longitudinal survey.
         The two cached data files will have file extensions of .txt and .meta.
}
\examples{
\dontrun{
setwd("C:/B&B2001/ecbw/B01")

dervFP <- file.path(getwd(), "Data", "B01DER.dat")
wgtFP <- file.path(getwd(), "Data", "B01WT.dat")
mstFP <- file.path(getwd(), "master.txt")

# with verbose output as default
bb2001 <- readBB_2001(dervFP, wgtFP, mstFP)

# silent output
bb2001 <- readBB_2001(dervFP, wgtFP, mstFP, verbose=FALSE)

# force cache update
bb2001 <- readBB_2001(dervFP, wgtFP, mstFP, forceReread = TRUE)
}
}
\seealso{
\code{\link{readECLS_K2011}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
