% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showPlausibleValues.R
\name{hasPlausibleValue}
\alias{hasPlausibleValue}
\title{Plausible Value Test}
\usage{
hasPlausibleValue(var, data)
}
\arguments{
\item{var}{a character indicating the variable in question}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame},
or an \code{edsurvey.data.frame.list}}
}
\value{
a Boolean (or vector when \code{var} is a vector) indicating if each element of \code{var} has
        plausible values associated with it
}
\description{
Returns a value indicating if this variable has associated plausible values in an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}.
}
\details{
This function returns \code{TRUE} only when the variable passed to it is the name for a set of plausible values but
         not if it is an individual plausible value from such a set. Thus, on the NAEP Primer, \code{composite} has plausible
         values (and so \code{TRUE} would be returned by this function), but any of the plausible values or variable names defined in
         the actual data (such as \code{"mrpcm1"} or \code{"dsex"}) are not.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# TRUE
hasPlausibleValue(var="composite", data=sdf)

# FALSE
hasPlausibleValue(var="dsex", data=sdf)
}
\author{
Michael Lee and Paul Bailey
}
