% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourPlot.R
\name{contourPlot}
\alias{contourPlot}
\title{Overlaid Scatter and Contour Plots}
\usage{
contourPlot(
  x,
  y,
  m = 30L,
  xrange,
  yrange,
  xkernel,
  ykernel,
  nlevels = 9L,
  colors = heat.colors(nlevels),
  ...
)
}
\arguments{
\item{x}{numeric vector of the \code{x} data to be plotted}

\item{y}{numeric vector of the \code{y} data to be plotted}

\item{m}{integer value of the number of \code{x} and \code{y} grid points}

\item{xrange}{numeric vector of length two indicating \code{x}-range of plot;
defaults to range(x)}

\item{yrange}{numeric vector of length two indicating \code{y}-range of plot;
defaults to range(y)}

\item{xkernel}{numeric indicating the standard deviation of Normal
\code{x} kernel to use in generating contour plot}

\item{ykernel}{numeric indicating the standard deviation of Normal
\code{y} kernel to use in generating contour plot}

\item{nlevels}{integer with the number of levels of the contour plot}

\item{colors}{colors to use, specified as in \ifelse{latex}{\code{par}}{\code{\link[graphics]{par}}}.
Defaults to the \ifelse{latex}{\code{heat.colors}}{\code{\link[grDevices]{heat.colors}}}
with \code{nlevels}. When specified, \code{colors} overrides \code{nlevels}.}

\item{\dots}{additional arguments to be passed to a plot call that generates the
scatter plot and the contour plot}
}
\description{
Diagnostic plots for regressions can become too dense to interpret.
             This function helps by adding a contour plot over the points to 
             allow the density of points to be seen, even when an area is entirely covered in points.
}
\examples{
\dontrun{
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))
lm1 <- lm.sdf(composite ~ pared * dsex + sdracem, sdf)
# plot the results
contourPlot(x=lm1$fitted.values,
	          y=lm1$residuals[,1], # use only the first plausible value
	          m=30,
	          xlab="fitted values",
	          ylab="residuals",
	          main="Figure 1")
# add a line indicating where the residual is zero
abline(0,0)
}
}
\author{
Yuqi Liao and Paul Bailey
}
