% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTIMSSAdv.R
\name{downloadTIMSSAdv}
\alias{downloadTIMSSAdv}
\title{Download and Unzip TIMSS Advanced Files}
\usage{
downloadTIMSSAdv(years = c(1995, 2008, 2015), root, cache = FALSE)
}
\arguments{
\item{years}{an integer vector of the assessment years to download. Valid years are 1995, 2008, and 2015.}

\item{root}{a character string indicating the directory where the TIMSS Advanced
data should be stored. Note that files are placed in a
subdirectory named TIMSSAdv[year].}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of 
the data. Default value is \code{FALSE}.}
}
\description{
Uses an Internet connection to download TIMSS Advanced data.
             Data comes from \href{https://timssandpirls.bc.edu/}{timssandpirls.bc.edu} zip files. This
             function works for 1995, 2008, and 2015 data.
}
\examples{
\dontrun{
  # root argument will vary by operating system conventions
  downloadTIMSSAdv(year=c(2008, 2015), root = "C:/")
  
  # cache=TRUE will download then process the datafiles
  downloadPIRLS(year=2015, root = "C:/", cache = TRUE)
}
}
\seealso{
\code{\link{readTIMSSAdv}}
}
\author{
Tom Fink
}
