% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/niche_overlap_null.R
\name{plot.nichenullmod}
\alias{plot.nichenullmod}
\title{Niche Null Model Plot function}
\usage{
\method{plot}{nichenullmod}(x, type = "hist", ...)
}
\arguments{
\item{x}{the null model object to plot.}

\item{type}{the type of null model plot to display.  See details for more information.}

\item{...}{Other variables to be passed on to base plotting.}
}
\description{
Plot niche overlap null model object.
}
\details{
the valid types for the Niche Overlap module are "hist" to display a histogram of the simulated metric values, and "niche" to display the observed data matrix and one simulated matrix.

The "hist" plot type is common to all EcoSimR modules. The blue histogram represents the NRep values of the metric for the simulated assemblages. The red vertical line represents the metric value for the real assemblage. The two pairs of vertical dashed black lines represent the one-tailed (long dash) and two-tailed (short dash) 95% confidence exact confidence intervals of the simulated data.

The "niche" plot type illustrates the utilization data (observed = red, simulated = blue). Each row in the figure is a species, and each column is a resource utilization category. The area of each circle depicted is proportional to the utilization of a resoruce category by a species. Empty positions indicate a resource utilization of 0.0. The rows and columns are illustrated with the same ordering as the original data matrix.
}

