% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.theilsen.R
\name{eco.theilsen}
\alias{eco.theilsen}
\title{Theil-sen regression for a raster time series}
\usage{
eco.theilsen(stacked, date, adjust = "none")
}
\arguments{
\item{stacked}{Stacked images ("RasterLayer"  or "RasterBrick").}

\item{date}{data vector with dates for each image.}

\item{adjust}{P-values correction method for multiple tests
passed to \code{\link[stats]{p.adjust}}. Defalut is "none".}
}
\description{
This function computes the theil-sen estimator and
the P-value associated for each pixel over time in a stack of images,
writing the values in a raster (one for the estimators and one for
the P-values). It is recommended to use a "RasterBrick", that
is more efficient in managing memory.
}
\examples{
\dontrun{

require("raster")
require("animation")
set.seed(6)

temp <- list()

for(i in 1:100) {
temp[[i]] <- runif(36,-1, 1)
temp[[i]] <- matrix(temp[[i]], 6, 6)
temp[[i]] <- raster(temp[[i]])
}

temp <- brick(temp)

oopt <- ani.options(interval = 0.01)
for (i in 1:ani.options("nmax")) {
plot(temp[[i]])
ani.pause()
}
ani.options(oopt)

writeRaster(temp,"temporal.tif", overwrite=T)
rm(temp)
ndvisim <- brick("temporal.tif")

date <- seq(from = 1990.1, length.out = 100, by = 0.2)

eco.theilsen(ndvisim, date)

pvalue <- raster("pvalue.tif")
slope <- raster("slope.tif")
par(mfrow = c(1, 2))
plot(pvalue, main = "p-value")
plot(slope, main = "slope")
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Sen, P. 1968. Estimates of the regression coefficient based on Kendall's tau.
Journal of the American Statistical Association, Taylor and Francis Group, 63: 1379-1389.

Theil H. 1950. A rank-invariant method of linear and polynomial regression analysis,
Part 3 Proceedings of Koninalijke Nederlandse Akademie van Weinenschatpen A, 53: 397-1412.
}
\seealso{
\code{\link[rkt]{rkt}}.
}

