% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.malecot.R
\name{eco.malecot}
\alias{eco.malecot}
\title{Global and local kinship analyses (beta version)}
\usage{
eco.malecot(eco, method = c("global", "local"), kinmatrix = NULL,
  int = NULL, smin = 0, smax = NULL, nclass = NULL, kmax = NULL,
  seqvec = NULL, size = NULL, type = c("knearest", "radialdist"),
  cubic = TRUE, testclass.b = TRUE, testmantel.b = TRUE,
  jackknife = TRUE, cummulative = FALSE, nsim = 99,
  test = c("permutation", "bootstrap"), alternative = c("auto", "two.sided",
  "greater", "less"), sequential = TRUE, conditional = c("AUTO", "TRUE",
  "FALSE"), bin = c("sturges", "FD"), row.sd = FALSE, adjust = "holm",
  latlon = FALSE)
}
\arguments{
\item{eco}{Object of class ecogen.}

\item{method}{Analysis method: "global" or "local".}

\item{kinmatrix}{Alternative kinship matrix. The program computes
the Loiselle's kinship matrix (codominant data) with the genetic information
of the ecogen object if kinmatrix = NULL (Defaul option).}

\item{int}{Distance interval in the units of XY.}

\item{smin}{Minimum class distance in the units of XY.}

\item{smax}{Maximum class distance in the units of XY.}

\item{nclass}{Number of classes.}

\item{kmax}{Number of nearest-neighbors for local analysis.}

\item{seqvec}{Vector with breaks in the units of XY.}

\item{size}{Number of individuals per class.}

\item{type}{Weight mode for local analyis: "knearest" for nearest neigbors,
"radialdist" for radial distances. Default is knearest.}

\item{cubic}{Should be performed a cubic interpolation (res~ ln(dij))
with the regression residuals (res)  of (kinship)ij ~ ln(dij) ? Defalut TRUE.}

\item{testclass.b}{Should be performed a permutation test in each individual class? Defalut TRUE.}

\item{testmantel.b}{Should be performed a Mantel test for testing the slope (b)? Defalut TRUE.}

\item{jackknife}{Should be performed jackknife in each individual class for computing
the standard deviation (SD) of the coancestry (class) values? Defalut TRUE.}

\item{cummulative}{Should be construced a cummulative correlogram?.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{test}{If test = "bootstrap", the program generates a bootstrap
resampling and the associated confidence intervals of the null hypothesis.
 If test = "permutation" (default) a permutation test is made and the P-values
 are computed.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the alternative hypothesis.
Other options are: "two.sided", "greater" and "less".}

\item{sequential}{Should be performed a Holm-Bonberroni (Legendre and Legendre, 2012)
adjustment of P-values for global analysis? Defalult TRUE.}

\item{conditional}{Logical. Should be used a conditional randomization? (Anselin 1998, Sokal and Thomson 2006). The option "auto"
sets conditional = TRUE for LISA methods and G, as suggested by Sokal (2008).}

\item{bin}{Rule for constructing intervals when a partition parameter (int,
nclass or size) is not given. Default is Sturge's rule (Sturges, 1926). Other
option is Freedman-Diaconis method (Freedman and Diaconis, 1981).}

\item{row.sd}{Logical. Should be row standardized the matrix? Default FALSE
(binary weights).}

\item{adjust}{P-values correction method for multiple tests
passed to \code{\link[stats]{p.adjust}}. Defalut is "holm".}

\item{latlon}{Are the coordinates in decimal degrees format? Defalut FALSE. If TRUE,
the coordinates must be in a matrix/data frame with the longitude in the first
column and latitude in the second. The position is projected onto a plane in
meters with the function \code{\link[SoDA]{geoXY}}.}
}
\value{
NOTE: THIS IS A BETA VERSION OF THE FUNCTION (UNDER DEVELOPMENT).


For the global analysis, the program returns an object of class "eco.IBD"
with the following slots:

> OUT analysis output.


In the permutation test case contains:
- d.mean: mean class distance;
- d.log: mean logarithm of the class distance;
- obs, exp, alter, p.val: observed, and expected value of the statistic
under randomization, alternative, P value;
- mean.jack, sd.jack, Jack.CI.inf, Jack.CI.sup: jackknifed mean and SD,
and confidence intervals for the statistic;
- null.lwr, nul.uppr: lower and upper bound of the jackknife
 confidence interval for the statistic;
- cardinal: number of individuals in each class;


In the bootstrap test case contains:
- d.mean: mean class distance;
- d.log: mean logarithm of the class distance;
- obs: observed value of the statistic;
- mean.jack, sd.jack, Jack.CI.inf, Jack.CI.sup: jackknifed mean and SD,
and confidence intervals for the statistic;
- null.lwr, nul.uppr: lower and upper bound of the jackknife
 confidence interval for the statistic;
- cardinal: number of individuals in each class;

> IN analysis input data

> SP Sp statistic results


It contains:

- the regression model;
- information about the distance interval used
for the regression (restricted);
-  slope (bhat) information (bhat = estimate, SD= bhat jacknife SD, theta =  bhat jackknife mean,
CI 5\% and 95\% = 95\% confidence interval for bhat);
-  X-intercept = dij intercept (in the original units) for the line with slope "bhat",
F1 = first class statistic value, and  F1 5\% and 95\% = confidence interval
for the first class statistic;
- mantel.obs.b = observed value of the Mantel test between
kinship(Fij) and ln(dij); mantel.pval.b = Mantel test P value;
- sp = Sp statistics (sp = Sp observed value,
CI 5\% and 95\% = 95\% confidence interval
for Sp);
- cubic_model = cubic model for (kinship)ij ~ ln(dij) r
esiduals vs ln(dij);

> BEAKS breaks

> CARDINAL number of elements in each class

> NAMES variables names

> METHOD analysis method

> DISTMETHOD method used in the construction of breaks

> TEST test method used (bootstrap, permutation)

> NSIM number of simulations

> PADJUST P-values adjust method for permutation tests

------

For the local analysis, the program returns an object of class "eco.lsa"
with the following slots:

> OUT results


> In the permutation test case contains:

- d.mean: mean class distance
- obs, exp, alter, p.val: observed, and expected value of the statistic
under randomization, alternative, P value;
- null.lwr, nul.uppr: lower and upper bound of the jackknife
 confidence interval for the statistic;
- cardinal: number of individuals in each class;


> In the bootstrap test case contains:
- d.mean: mean class distance;
- obs: observed value of the statistic;
- null.lwr, nul.uppr: lower and upper bound of the jackknife;
 confidence interval for the statistic;
- cardinal: number of individuals in each class;

> METHOD method (coefficent) used in the analysis

> TEST test method used (bootstrap, permutation)

> NSIM number of simulations

> PADJUST P-values adjust method for permutation tests

> COND conditional randomization (logical)

> XY input coordinates


\strong{ACCESS TO THE SLOTS}
The content of the slots can be accessed
with the corresponding accessors, using
the generic notation of EcoGenetics
(<ecoslot.> + <name of the slot> + <name of the object>).
See help("EcoGenetics accessors") and the Examples
section below.
}
\description{
NOTE: THIS IS A BETA VERSION OF THE FUNCTION (UNDER DEVELOPMENT).
The program computes a global multilocus correlogram, or a local analysis, using a
kinship matrix. When a kinship matrix is not given as input, the program
computes the Loiselle's Fij (Kalisz et al., 2001; Loiselle et al., 1995).
}
\details{
The GLOBAL ANALYSIS mode, computes a multilocus correlogram, with a detailed
summary (see the content of the slot OUT  in the "return" section).
It also computes (see details about the slot SP in the "return" section):
- the slope of the kinship individual values vs the logarithm of the distance, (kinship)ij ~ ln(dij), with a jackknife confidence
interval
- a Mantel test for testing the association between  (kinship)ij
and ln(dij)
- The Sp statistic (Vekemans and Hardy, 2004) with confidence intervals
- A cubic interpolation of (kinship)ij ~ ln(dij) residuals vs ln(dij)


The LOCAL ANALYSIS mode, computes a local kinship estimate, based in a weighted
mean (for the each individual). The signification of each local statistic
is computed using a permutation test, as in eco.lsa (see ?"eco.lsa").
Default option do not adjust the individual P values
for multiple corrections.
}
\examples{
\dontrun{

data(eco.test)

# ---global analysis---

globaltest <- eco.malecot(eco=eco, method = "global", smax=10,
                         size=1000)
plot(globaltest)    # Significant mean class coancestry classes at
                    # individual level (alpha = 0.05,
                    # out of the red area),
                    # and family-wise P corrected values (red-blue
                    # points, indicated in the legend)

# ecoslot.SP(globaltest) contains:
# - the slope (bhat) and values with confidence intervals
#  of the regression reg = kinship ~ ln(distance_between_individuals)
#- A Mantel test result for assesing the relation between
#  between  kinship and ln(distance_between_individuals)
#- A cubic interpolation between the residuals of reg and
#  ln(distance_between_individuals)
#- the sp statistic and its confidence interval

# ecoslot.OUT(globaltest) contains:
# - In permutation case, the values of mean and log-mean distance
#   classes; observed class value; expected + alternative + P value,
#   the bootstrap null confidence intervals and
#   jackknife statistics (jackknifed mean, jackknifed SD, and
#                         CI for the class statistic)

# - In bootstrap case, the values of mean and log-mean distance
#   classes;the bootstrap null confidence intervals and
#   jackknife statistics (jackknifed mean, jackknifed SD, and
#                         CI for the class statistic)

#----------------------------------------------------------#
# ---local analysis---


(using the spatial weights).

# ---local analysis with k nearest neighbors---



localktest <- eco.malecot(eco=eco, method = "local",
                         type = "knearest", kmax = 5,
                         adjust = "none")
plot(localktest)


# ---local analysis with radial distance---

localdtest <- eco.malecot(eco=eco, method = "local",
                        type = "radialdist", smax = 3,
                        adjust = "none")

plot(localdtest)                         # rankplot graphic (see ?"eco.rankplot")

                                         # Significant values
                                         # in blue-red scale,
                                         # non significant
                                         # values in yellow

plot(localktest, significant = FALSE)    # significant and non
                                         # signficant values
                                         # in blue-red scale

# The slot OUT of localktest (ecoslot.OUT(localktest)) and localdtest
# (ecoslot.OUT(localdtest)) contains:
# - the mean distance per individual, observed value of the
#   statistic, expected + alternative + P value + null hypotesis
#   confidence intervals,  or boostrap confidence intervals in
#   permutation or bootstrap cases, respectively.
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Double M., R. Peakall, N. Beck, and Y. Cockburn. 2005.
Dispersal, philopatry, and infidelity: dissecting
local genetic structure in superb fairy-wrens (Malurs cyaneus).
Evolution 59: 625-635.

Kalisz S., J. Nason, F.M. Handazawa, and S. Tonsor. 2001.
Spatial population genetic structure in Trillium grandiflorum:
the roles of dispersal, mating, history, and selection.
Evolution 55: 1560-1568.

Loiselle B., V. Sork, J. Nason, and C. Graham. 1995.
Spatial genetic structure of a tropical understory shrub,
Psychotria officinalis (Rubiaceae).
American Journal of Botany 1420-1425.

Vekemans, X., and O. Hardy. 2004. New insights from fine-scale
spatial genetic structure analyses in plant populations.
Molecular Ecology, 13: 921-935.
}

