% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.autocor.R
\name{eco.autocor}
\alias{eco.autocor}
\title{Moran's I, Geary's C, Join-Count, local Getis-Ord's G and local Moran's I
correlograms for an ecogen object}
\usage{
eco.autocor(eco, int, smax, df = c("P", "G", "E", "GENIND", "C"),
  select = c("moran", "geary", "joincount", "getisord", "localmoran"),
  nsim = 99, indvar = NULL, w = c("B", "W"), latlon = FALSE,
  fact = NA, grp = NA, ncod = NULL, ...)
}
\arguments{
\item{eco}{ecogen object for the analysis.}

\item{int}{Lag class interval distance in meters.}

\item{smax}{Maximum lag distance in meters.}

\item{df}{Data frame in eco to analyze.}

\item{select}{Analysis to perform. Can be "moran", "geary" , "joincount", "getisord",
"localmoran".}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{indvar}{Name of the variable in df when a single trait should be analyzed
instead of the complete df data.}

\item{w}{Weight matrix style. "B" for binary (default) or "W" for row standardized.}

\item{latlon}{Logical. Are the coordinates in decimal degrees format? Default FALSE.}

\item{fact}{The name of the S slot column when analysis per-group is required.
Default analysis takes in account all sites.}

\item{grp}{The group (contained in fact) to analyze if analysis
per-group is required. Default analysis takes in account all sites.}

\item{ncod}{number of characters coding the information in each cell of df
for Join-Count analysis.}

\item{...}{Further arguments passed to \code{\link{eco.moran}} \code{\link{eco.geary}}
\code{\link{eco.joincount}}, \code{\link{eco.getisord}} or \code{\link{eco.localmoran}}}
}
\value{
The program returns an object with data frames containing the statistic,
the mean class distance interval and the 95\% upper and lower confidence
interval bounds of the null hypoteses estimated by bootstrap.
}
\description{
This program can manipulate the different classes of data included
in an ecogen object. The action changes according to the data frame selected
and the statistic to compute. For Join-Count analysis it is require a ncod
argument (the number of characters in each cell) when df is not "GENIND".
When a single variable is the objective to analyze instead of a complete data frame,
it could be provided an "indvar" argument, with the name of the trait.
If the coordinates are given in decimal degrees, set latlon = TRUE.
In that case, a distance matrix is computed under a spherical Earth model.
A distance matrix with UTM coordinates is suggested as imput.
}
\examples{
\dontrun{
data(eco.test)

eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "P", select = "moran", nsim = 10)
plot(eco.ac, var = "P2")

eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "P", select = "geary", nsim = 10)
plot(eco.ac, var = "P2")

eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "GENIND", select = "joincount", nsim = 10,
indvar="L1.1")
plot(eco.ac)

eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "P", select = "getisord", nsim = 10)
plot(eco.ac, var = "P2")
eco.rankplot(eco.ac, eco$XY, "P2")
eco.forestplot(eco.ac, "P2")

eco.ac <- eco.autocor(eco, int = 200, smax = 2000,
df = "P", select = "localmoran", nsim = 10)
plot(eco.ac, var = "P2")
eco.rankplot(eco.ac, eco$XY, "P2")
eco.forestplot(eco.ac, "P2")

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

