% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{evalues.OLS}
\alias{evalues.OLS}
\title{Compute E-value for a linear regression coefficient estimate}
\usage{
evalues.OLS(est, se = NA, sd, delta = 1, true = 0)
}
\arguments{
\item{est}{The linear regression coefficient estimate (standardized or unstandardized)}

\item{se}{The standard error of the point estimate}

\item{sd}{The standard deviation of the outcome (or residual standard deviation); see Details}

\item{delta}{The contrast of interest in the exposure}

\item{true}{The true standardized mean difference to which to shift the observed point estimate. Typically set to 0 to consider a null true effect.}
}
\description{
Returns a data frame containing point estimates, the lower confidence limit, and the upper confidence limit
on the risk ratio scale (through an approximate conversion) as well as E-values for the point estimate and the confidence interval
limit closer to the null.
}
\details{
A true standardized mean difference for linear regression would use \code{sd} = SD(Y | X, C), where Y is
the outcome, X is the exposure of interest, and C are any adjusted covariates. See Examples for how to extract 
this from \code{lm}. A conservative approximation would instead use \code{sd} = SD(Y). Regardless, the reported E-value
for the confidence interval treats \code{sd} as known, not estimated.
}
\examples{
# first standardizing conservatively by SD(Y)
data(lead)
ols = lm(age ~ income, data = lead)

# for a 1-unit increase in income
evalues.OLS(est = ols$coefficients[2],
            se = summary(ols)$coefficients['income', 'Std. Error'],
            sd = sd(lead$age) )
            
# for a 0.5-unit increase in income
evalues.OLS(est = ols$coefficients[2],
            se = summary(ols)$coefficients['income', 'Std. Error'],
            sd = sd(lead$age),
            delta = 0.5 )
            
# now use residual SD to avoid conservatism
# here makes very little difference because income and age are
# not highly correlated
evalues.OLS(est = ols$coefficients[2],
            se = summary(ols)$coefficients['income', 'Std. Error'],
            sd = summary(ols)$sigma )
}
