% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqERboot.R
\name{seqERboot}
\alias{seqERboot}
\title{Computes sequential evidence ratios for a given data set and permutation samples}
\usage{
seqERboot(ic, mod1, mod2, nmin, id = NULL, order_nb)
}
\arguments{
\item{ic}{Indicates whether to use the aic or the bic.}

\item{mod1}{A model of class \code{lm} or \code{lmerMod}.}

\item{mod2}{A model of class \code{lm} or \code{lmerMod} (of the same class of mod1).}

\item{nmin}{Minimum sample size from which start to compute sequential evidence ratios.}

\item{id}{If applicable (i.e., repeated measures), name of the "id" column of your
dataframe, in character string.}

\item{order_nb}{Number of permutation samples to evaluate.}
}
\description{
Computes sequential evidence ratios for a given data set as well as
for \code{order_nb} random permutations of this dataset. When data involve repeated
measures (and so multiple lines per subject), a column indicating the
subject "id" should be provided to the \code{id} argument. If nothing
is passed to the \code{id} argument, \code{seqERboot} will suppose
that there is only one observation (i.e., one line) per subject.
}
\examples{
\dontrun{
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
mod2 <- lm(mpg ~ cyl + disp, mtcars)
seq_boot_mtcars <- seqERboot(ic = bic, mod1, mod2, nmin = 10, order_nb = 20)

# Example with repeated measures
library(lme4)
data(sleepstudy)
mod1 <- lmer(Reaction ~ Days + (1|Subject), sleepstudy)
mod2 <- lmer(Reaction ~ Days + I(Days^2) + (1|Subject), sleepstudy)
seqERboot(ic = bic, mod1, mod2, nmin = 10, id = "Subject", order_nb = 20)}

}
\seealso{
\code{\link{seqER}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
