% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Diabetes}
\alias{Diabetes}
\title{Diabetes data}
\usage{
data(Diabetes)
}
\description{
A \code{data.frame} with a design and transcriptomic data.
}
\details{
Clinical study on humans was performed as a 2-way factorial design with two factors
both on two levels: bariatric surgery on two levels (before and after the bariatric
surgery) and type 2 diabetes (T2D) on two levels (with and without T2D). There were
8 patients without T2D and 7 with T2D. It was discovered that the patients with T2D
would be separated in two groups: 3 patients in the group called T2D1 and 4 patients
in the group called T2D2. The experiment can therefor also analysed as 2 way factorial
design where the disease factor is on three levels. All patients were obese before
bariatric surgery (BMI >45). Transcriptome in the subcutaneous adipose tissue were
obtained before and one year after bariatric surgery.
}
\examples{
data(Diabetes)
str(Diabetes)

}
\references{
Dankel et al. 2010. Switch from Stress Response to Homeobox Transcription Factors in Adipose Tissue After Profound Fat Loss. Plos One 5.
}
\author{
Ellen Færgestad Mosleth
}
