% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leafepp.R
\name{leafepp}
\alias{leafepp}
\title{leafepp}
\usage{
leafepp(x, t, crs, leng = "es", ...)
}
\arguments{
\item{x}{List obtained from eppexist or eppproy}

\item{t}{Character "exist" or "proy" depending of input structure}

\item{crs}{Coordinate Reference Systems (CRS).}

\item{leng}{Lenguage of labels. Available english ("en" ) and spanish ("es"). Default "es"}

\item{...}{leaflet options and parameters}
}
\value{
leaflet
}
\description{
template of leaflet map for {eppexist} or {eppproy} outputs
}
\examples{
## In case of eppexist

exist <- eppexist(pop = pop_epp, 
                  centers = centers_epp, 
                  crs = sp::CRS("+init=epsg:32721"))
l_epp_exist <- leafepp(exist, t = "exist", crs = sp::CRS("+init=epsg:32721"))

## In case of eppproy

proy <- eppproy(pop = exist$pop_uncover)
l_epp_proy <- leafepp(proy, t = "proy", crs = sp::CRS("+init=epsg:32721"))
}
