% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangebreak.linear.R
\name{rangebreak.linear}
\alias{rangebreak.linear}
\title{rangebreak.linear Conduct a linear rangebreak test as described in Glor and Warren 2011.}
\usage{
rangebreak.linear(
  species.1,
  species.2,
  env,
  type,
  f = NULL,
  nreps = 99,
  nback = 1000,
  bg.source = "default",
  low.memory = FALSE,
  rep.dir = NA,
  ...
)
}
\arguments{
\item{species.1}{An emtools.species object}

\item{species.2}{An enmtools.species object}

\item{env}{A RasterLayer or RasterStack object containing environmental data}

\item{type}{The type of model to construct, currently accepts "glm", "mx", "bc", "gam", or "dm"}

\item{f}{A function to use for model fitting.  Only required for GLM models at the moment.}

\item{nreps}{Number of replicates to perform}

\item{nback}{Number of background points for models}

\item{bg.source}{Source for drawing background points.  If "points", it just uses the background points that are already in the species object.  If "range", it uses the range raster.  If "env", it draws points at randome from the entire study area outlined by the first environmental layer.}

\item{low.memory}{When set to TRUE, replicate models are written to disc instead of being stored in the output object.  Replicate models stored in the output object contain paths to the replicate models on disk instead of the rasters themselves.}

\item{rep.dir}{Directory for storing replicate models when low.memory is set to TRUE.  If not specified, the working directory will be used.}

\item{...}{Additional arguments to be passed to model fitting functions.}
}
\value{
results A list containing the replicates, models for the empirical data, and summary statistics and plots.
}
\description{
rangebreak.linear Conduct a linear rangebreak test as described in Glor and Warren 2011.
}
\examples{
\donttest{
data(iberolacerta.clade)
data(euro.worldclim)
cyreni <- iberolacerta.clade$species$cyreni
aranica <- iberolacerta.clade$species$aranica
rangebreak.linear(cyreni, aranica, env = euro.worldclim, type = "glm",
f= pres ~ bio1 + bio12, nreps = 10)
}
}
\keyword{barrier}
\keyword{biogeography}
\keyword{enmtools}
\keyword{hypothesis-testing}
\keyword{rangebreak}
