% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{embc}
\alias{embc}
\title{General pourpose multivariate binary Clustering (EMbC)}
\usage{
embc(X, U = NULL, stdv = NULL, maxItr = 200, info = 0)
}
\arguments{
\item{X}{The input data set. A multivariate matrix where each row is a data point and each column is an input feature (a variable).}

\item{U}{A multivariate matrix with same dimension as X with the values of certainty associated to each corresponding value in X. Certainties assign reliability to the data points so that the less reliable is a data point the less its leverage in the clustering. By default certainties are set to one (no uncertainty in any value in X).}

\item{stdv}{a vector with bounds for the maximum precision of clusters, given as minimum standard deviation for each variable, (by default is set to rep(sqrt(.Machine$double.eps),ncol(X))}

\item{maxItr}{A limit to the number of iterations in case of slow convergence (defaults to 200).}

\item{info}{Level of information shown at each step:
info=0 (default) shows step likelihood, number of clusters, and number of changing labels;
info=1, include clustering statistics;
info=2, include delimiters information;
info<0, suppress any step information.}
}
\value{
Returns a binClst object.
}
\description{
\code{embc} implements the core function of the Expectation-Maximization multivariate binary clustering.
}
\examples{

# -- apply EMbC to the example set of data points x2d ---
mybc <- embc(x2d@D)
}
