% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSS.R
\name{confint.EMSS}
\alias{confint.EMSS}
\title{Getting Confidence Intervals for Parameters of EM type Sample Selection Model Fits}
\usage{
\method{confint}{EMSS}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class "EMSS" made by the function \code{EMSS}.}

\item{parm}{not used, but exists because of the compatibility.}

\item{level}{a numeric value between 0 and 1 for controlling the significance level of confidence interval; default value is 0.95.}

\item{...}{not used, but exists because of the compatibility.}
}
\description{
\code{confint} method for a class "EMSS".
}
\examples{
# examples continued from EMSS
data(Smoke, package = "EMSS")
ex1 <- EMSS(response = cigs_intervals ~ educ,
           selection = smoker ~ educ + age,
           data = Smoke)
confint(ex1)

data(Smoke, package = "EMSS")
ex2 <- EMSS(response = cigs_intervals ~ educ,
           selection =  smoker ~ educ + age,
           data = Smoke, method="ECMnr")
confint(ex2)

## example using random numbers with exclusion restriction

N <- 1000
errps <- mvtnorm::rmvnorm(N,c(0,0),matrix(c(1,0.5,0.5,1),2,2) )
xs <- runif(N)
ys <- xs+errps[,1]>0
xo <- runif(N)
yo <- (xo+errps[,2])*(ys>0)

ex3 <- EMSS(response = yo ~ xo,
           selection = ys ~ xs,
           initial.param = c(rep(0,4), 0.3, 0.6), method="ECMnr")
confint(ex3)

}
