% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_model.R
\name{identify_model}
\alias{identify_model}
\title{identify_model}
\usage{
identify_model(x, dy, tol)
}
\arguments{
\item{x}{Observed input data (n x m matrix of finite numeric elements).}

\item{dy}{Observed output differences data (n x 1 matrix of finite numeric elements).}

\item{tol}{A tolerance parameter of the golden section search algorithm used for minimizing the one-dimensional likelihood function (vector of length 1, finite positive numeric element).}
}
\value{
A list consisting of 3 elements: 1) estimate of the covariance of cbind(x, dy) at lag 0 (Sigma; (m + 1) x (m + 1) matrix of numeric elements); 2) estimate of the only non-zero element of the negative covariance of cbind(x, dy) at lag 1 (sigma_y^2; vector of length 1, numeric element); 3) estimate of the mean of cbind(x, dy) (mu; (m + 1) x 1 matrix of numeric elements).
}
\description{
Calculates maximum likelihood estimates of the statistical parameters of the one-dimensional cumulative structural equation model with normality assumptions.
}
\examples{
set.seed(1)

m <- 4
k <- 2

L <- matrix(runif((m + 1) * k, min = -10, max = 10), nrow = m + 1)
sigma <- matrix(runif(m + 2, min = 0, max = 10), nrow = m + 2)
mu <- matrix(runif(m + 1, min = -10, max = 10), nrow = m + 1)

data <- generate_data(100, L, sigma, mu)

identify_model(data[[1]], data[[2]], 0.00001)

}
