% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRI.R
\name{split_timeseries}
\alias{split_timeseries}
\title{Split fMRI Timeseries Data by ROI Columns}
\usage{
split_timeseries(timeseries, columns = NULL)
}
\arguments{
\item{timeseries}{A data frame containing fMRI timeseries data with required columns
'subjects', 'run', and 'time', plus one or more ROI columns.}

\item{columns}{A character vector specifying which columns to split by. If NULL (default),
all columns except 'subjects', 'run', and 'time' will be used.}
}
\value{
A named list of data frames, where each data frame contains the common columns
(subjects, run, time) and one ROI column. The names of the list elements correspond
to the ROI column names.
}
\description{
This function splits a timeseries data frame containing multiple ROI columns into a list
of data frames, where each data frame contains the common columns (subjects, run, time)
and one ROI column.
}
\examples{
# Create a simple example timeseries with multiple ROIs
set.seed(123)
n_frames <- 100

# Create a data frame with multiple ROIs
timeseries <- data.frame(
  subjects = rep(1, n_frames),
  run = rep(1, n_frames),
  time = seq(0, n_frames-1),
  ROI1 = rnorm(n_frames),
  ROI2 = rnorm(n_frames),
  ROI3 = rnorm(n_frames)
)

# Split the timeseries by all ROI columns
split_data <- split_timeseries(timeseries)
}
