% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_defective_density}
\alias{plot_defective_density}
\title{Plot defective densities for each subject and cell}
\usage{
plot_defective_density(
  data,
  subject = NULL,
  factors = NULL,
  layout = NA,
  correct_fun = NULL,
  rt_pos = "top",
  accuracy = "topright",
  ...
)
}
\arguments{
\item{data}{A data frame. The experimental data in EMC2 format with at least \code{subject} (i.e., the
subject factor), \code{R} (i.e., the response factor) and \code{rt} (i.e., response time) variable.
Additional factor variables of the design are optional.}

\item{subject}{An integer or character string selecting a subject from the data.
If specified, only that subject is plotted. Per default (i.e., \code{NULL}), all subjects
are plotted.}

\item{factors}{A character vector of the factor names in the design to aggregate across
Defaults to all (i.e., \code{NULL}).}

\item{layout}{A vector indicating which layout to use as in par(mfrow = layout). If NA, will automatically generate an appropriate layout.}

\item{correct_fun}{If specified, the accuracy for each subject is calculated, using the supplied function and
an accuracy vector for each subject is returned invisibly.}

\item{rt_pos}{legend function position character string for the mean response time (defaults to \code{top})}

\item{accuracy}{legend function position character string for accuracy (defaults to \code{topright})}

\item{...}{Optional arguments that can be passed to \code{get_pars}, \code{density}, or \code{plot.default} (see \code{par()})}
}
\value{
If \code{correct_fun} is specified, a subject accuracy vector is returned invisibly
}
\description{
Plots panels that contain a set of densities for each response option in the data.
These densities are defective; their areas are relative to the respective
response proportion. Across all responses, the area sums to 1.
}
\examples{
# First for each subject and the factor combination in the design:
plot_defective_density(forstmann)
# Now collapsing across subjects:
plot_defective_density(forstmann, factors = c("S", "E"))
# If the data is response coded, it generally makes sense to include the "S" factor
# because EMC2 will plot the "R" factor automatically. This way, choice accuracy can
# be examined
# Each subject's accuracy can be returned using a custom function:
print(plot_defective_density(forstmann, correct_fun = function(d) d$R == d$S))

}
