% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{compare_subject}
\alias{compare_subject}
\title{Information criteria for each participant}
\usage{
compare_subject(
  sList,
  stage = "sample",
  filter = 0,
  use_best_fit = TRUE,
  print_summary = TRUE,
  digits = 3
)
}
\arguments{
\item{sList}{List of samples objects}

\item{stage}{A string. Specifies which stage the samples are to be taken from \code{"preburn"}, \code{"burn"}, \code{"adapt"}, or \code{"sample"}}

\item{filter}{An integer or vector. If it's an integer, iterations up until the value set by \code{filter} will be excluded.
If a vector is supplied, only the iterations in the vector will be considered.}

\item{use_best_fit}{Boolean, defaults to \code{TRUE}, use minimal likelihood or mean likelihood
(whichever is better) in the calculation, otherwise always uses the mean likelihood.}

\item{print_summary}{Boolean (defaults to \code{TRUE}) print table of results}

\item{digits}{Integer, significant digits in printed table}
}
\value{
List of matrices for each subject of effective number of parameters,
mean deviance, deviance of mean, DIC, BPIC and associated weights.
}
\description{
Returns the BPIC/DIC based model weights for each participant in a list of samples objects
}
\examples{
\dontrun{
# Define a list of two (or more different models)
# Here the full model is an emc object with the hypothesized effect
# The null model is an emc object without the hypothesized effect
design_full <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# Now without a ~ E
design_null <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~1, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))

full_model <- make_emc(forstmann, design_full)
full_model <- fit(full_model, cores_for_chains = 1)

null_model <- make_emc(forstmann, design_null, cores_for_chains = 1)
null_model <- fit(null_model)
sList <- list(full_model, null_model)
compare_subject(sList)
# prints a set of weights for each model for the different participants
# And returns the DIC and BPIC for each participant for each model.
}
}
