% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{eia_metadata}
\alias{eia_metadata}
\title{Pull Metadata from EIA API}
\usage{
eia_metadata(api_path = NULL, api_key)
}
\arguments{
\item{api_path}{A string, the API category/route path following the API endpoint (i.e., 'https://api.eia.gov/v2/')
If set to NULL (default) or as empty string "" it returns the main categories available on the API.
The path can be found on the EIA API dashboard, for more details see https://www.eia.gov/opendata/browser/}

\item{api_key}{A string, EIA API key, see https://www.eia.gov/opendata/ for registration to the API service}
}
\value{
a list object with the series description and metadata
}
\description{
Get data descriptions and metadata from the EIA API
}
\details{
The function enables to explore the different data categories and available routes
inline with the API dashboard (https://www.eia.gov/opendata/browser/)
}
\examples{
\dontrun{
electricity_metadata <- eia_metadata(api_key = Sys.getenv("eia_key"),
                                     api_path = "electricity")

electricity_metadata$response$description
electricity_metadata$response$id
electricity_metadata$response$name
electricity_metadata$response$routes

}
}
