% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelEstimation.R
\name{setUpEstimation}
\alias{setUpEstimation}
\title{setUpEstimation}
\usage{
setUpEstimation(eList, windowY = 7, windowQ = 2, windowS = 0.5,
  minNumObs = 100, minNumUncen = 50, edgeAdjust = TRUE, verbose = TRUE,
  interactive = NULL)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{windowY}{numeric specifying the half-window width in the time dimension, in units of years, default is 7}

\item{windowQ}{numeric specifying the half-window width in the discharge dimension, units are natural log units, default is 2}

\item{windowS}{numeric specifying the half-window with in the seasonal dimension, in units of years, default is 0.5}

\item{minNumObs}{numeric specifying the miniumum number of observations required to run the weighted regression, default is 100}

\item{minNumUncen}{numeric specifying the minimum number of uncensored observations to run the weighted regression, default is 50}

\item{edgeAdjust}{logical specifying whether to use the modified method for calculating the windows at the edge of the record.
The modified method tends to reduce curvature near the start and end of record.  Default is TRUE.}

\item{verbose}{logical specifying whether or not to display progress message}

\item{interactive}{logical deprecated. Use 'verbose' instead}
}
\value{
eList named list with Daily, Sample, and INFO dataframes.
}
\description{
Set up the INFO data frame for a modelEstimation
}
\examples{
eList <- Choptank_eList
eList <- setUpEstimation(eList)

}
\keyword{statistics}
\keyword{water-quality}
