% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConcTimeDaily.R
\name{plotConcTimeDaily}
\alias{plotConcTimeDaily}
\title{Plot of the time series of daily concentration estimates and the sample values for the days that were sampled}
\usage{
plotConcTimeDaily(eList, yearStart = NA, yearEnd = NA,
  tinyPlot = FALSE, concMax = NA, printTitle = TRUE, cex = 0.8,
  cex.axis = 1.1, randomCensored = FALSE, cex.main = 1.1,
  customPar = FALSE, col = "black", lwd = 1, prettyDate = TRUE,
  usgsStyle = FALSE, ...)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{yearStart}{numeric specifying the starting date (expressed as decimal years, for example 1989.0) for the plot}

\item{yearEnd}{numeric specifiying the ending date for the plot}

\item{tinyPlot}{logical variable, if TRUE plot is designed to be short and wide, default is FALSE.}

\item{concMax}{number specifying the maximum value to be used on the vertical axis, default is NA (which allows it to be set automatically by the data)}

\item{printTitle}{logical variable if TRUE title is printed, if FALSE title is not printed (this is best for a multi-plot figure)}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{randomCensored}{logical. Show censored values as randomized.}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function 
(for example, adjusting margins with par(mar=c(5,5,5,5))). If customPar FALSE, EGRET chooses the best margins depending on tinyPlot.}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width}

\item{prettyDate}{logical use 'pretty' limits for date axis if TRUE, or force the yearStart/yearEnd as limits if FALSE}

\item{usgsStyle}{logical option to use USGS style guidelines. Setting this option
to TRUE does NOT guarantee USGS complience. It will only change automatically
generated labels}

\item{\dots}{arbitrary functions sent to the generic plotting function.  See ?par for details on possible parameters}
}
\description{
This plot is useful for visual examination of the ability of the WRTDS, or other model, to fit the 
data, seen in a time-series perspective. 
The graph is most useful when it covers a period of just a few years and not the complete record
but a complete record can be done by repeated use over a series of segments.

Although there are a lot of optional arguments to this function, most are set to a logical default. 

Data come from named list, which contains a Sample dataframe with the sample data, 
a Daily dataframe with the daily flow data,
and an INFO dataframe with metadata.
}
\examples{
eList <- Choptank_eList
# Water year:
plotConcTimeDaily(eList)
plotConcTimeDaily(eList, yearStart=1998,yearEnd=2001)
# Graphs consisting of Jun-Aug
eList <- setPA(eList, paStart=6,paLong=3)
plotConcTimeDaily(eList)
}
\seealso{
\code{\link{selectDays}}, \code{\link{genericEGRETDotPlot}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}
