% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/delScattering.R
\name{delScattering}
\alias{delScattering}
\title{Delete scattering rays}
\usage{
delScattering(EEM, rep = 0, first = 30, second = 40, third = 40,
  forth = 0)
}
\arguments{
\item{EEM}{A list containing EEM data as created by \code{\link{readEEM}} function.}

\item{rep}{(optional) Regions to be deleted are to be replaced with \code{rep}: 0 or NA}

\item{first}{(optional) Width of region to be deleted for first order scattering rays [nm]}

\item{second}{(optional) Width of region to be deleted for second order scattering rays [nm]}

\item{third}{(optional) Width of region to be deleted for third order scattering rays [nm]}

\item{forth}{(optional) Width of region to be deleted for forth order scattering rays [nm]}
}
\value{
A list similar to input \code{EEM} is returned but with all scattering rays deleted.
}
\description{
This function deletes two types of rays that are not related to fluorescence emission: (1) regions where emission wavelength is shorten than excitation light, (2) scattering rays and their second, third and forth order lights.
}
\examples{
data(applejuice)
drawEEM(delScattering(applejuice, NA), 1)
}
\references{
Fujita, K., Tsuta, M., Kokawa, M., and Sugiyama, J. (2010). Detection of deoxynivalenol using fluorescence excitation--emission matrix. Food and Bioprocess Technology, 3(6), 922--927.
}
\keyword{scattering}

