% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGraphphics.R
\name{plot.EDOIF}
\alias{plot.EDOIF}
\title{plot.EDOIF function}
\usage{
\method{plot}{EDOIF}(x, ..., NList, options, fontSize)
}
\arguments{
\item{x}{is an object of EDOIF class that contains the results of ordering inference.}

\item{...}{Signature for S3 generic function.}

\item{NList}{is a list of based categories users want to have in mean-difference CI plot.}

\item{options}{is an option of reporting EDOIF plot(s):
0 for reporting all plots, 1 for mean-difference CI plot, 2 for mean CI plot,
 and 3 for dominant-distribution network plot.}

\item{fontSize}{is a font size of text for all plots.}
}
\description{
plot.EDOIF is a support function for printing all plots of EDOIF framework:
 dominant-distribution network plot, mean CI plot, and mean-difference CI plot.
}
\examples{
# Generate simulation data with 100 samples per categories

simData<-SimNonNormalDist(nInv=100)

# Performing ordering infernce from simData

resultObj<-EDOIF(simData$Values,simData$Group)

# Plot results in graphic mode

plot(resultObj)


}
