% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.sandwich.R
\name{gof.sandwich}
\alias{gof.sandwich}
\title{GOF tests for general distributions using Sandwich estimation of covariance function}
\usage{
gof.sandwich(y, x = NULL, Fdist, thetahat, Score, m = max(n, 100), ...)
}
\arguments{
\item{y}{A random sample or the response of regression problem.}

\item{x}{The matrix of covariates.}

\item{Fdist}{User supplied function to compute probability integral transform of y.}

\item{thetahat}{Parameter estimates by MLE.}

\item{Score}{User supplied function to compute 3 components of the score function
an n by p matrix with entries partial log f(y_i,\eqn{\theta})/ partial theta_j.}

\item{m}{Eigenvalues are extracted for an m by m grid of the covariance function.}

\item{...}{Other inputs passed to \code{Fdist} and \code{Score} when needed.}
}
\value{
Cramér-von Mises, Anderson-Darling and Watson statistics and their P-values.
}
\description{
This function tests the hypothesis that data y come from
distribution \code{Fdist} with unknown parameter values theta.
Estimates of theta must be provided in \code{thetahat}.
}
\details{
It uses a large sample approximation to the limit distribution
based on the use of the score function components
to estimate the Fisher information and the limiting covariance
function of the empirical process.

The estimates \code{thetahat} should be roots of the likelihood equations.
}
\examples{
sample = rnorm(n=100,mean=0,sd=1)
mle = estimate.normal(sample)
cdf.normal.user = function(x,theta){
 pnorm(x,mean=theta[1],sd=theta[2])
}
score.normal.user = function(x,theta){
 sig=theta[2]
 mu=theta[1]
 s.mean= (x-mu)/sig
 s.sd= s.mean^2/sig-length(x)/sig
 cbind(s.mean/sig,s.sd)
}
output = gof.sandwich(y=sample,Fdist=cdf.normal.user,thetahat=mle,Score=score.normal.user,m=100)
output
}
\seealso{
\code{\link{gof}} for generic functions using \code{\link[CompQuadForm]{imhof}} function;
\code{\link{gof.bootstrap}} for generic functions using bootstrap method.
}
