% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{extend_lookup}
\alias{extend_lookup}
\title{Extend the lookup table}
\usage{
extend_lookup(
  lookup,
  ...,
  key_columns = get_key_cols(lookup),
  datasets = get_datasets(lookup)
)
}
\arguments{
\item{lookup}{[\code{data.frame(1)}]\cr the lookup table}

\item{...}{unused}

\item{key_columns}{[\code{list(n)}]\cr for experts only}

\item{datasets}{[\code{data.frame(n)}]\cr for experts only}
}
\value{
the lookup, extended
}
\description{
This utility extends the lookup table to include:
\itemize{
\item \code{n_id} the number of patients present in the dataset
\item \code{rows_per_id} the mean number of row per patient
\item \code{crfname} the actual name of the dataset
}
}
\examples{
#tm = read_trialmaster("filename.zip", pw="xx")
tm = edc_example_mixed()
load_list(tm)
.lookup
.lookup = extend_lookup(.lookup)
.lookup
}
