% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.R
\name{balance}
\alias{balance}
\alias{balance.default}
\alias{balance.formula}
\title{Measures of class balance}
\usage{
balance(...)

\method{balance}{default}(x, y, measures = "all", ...)

\method{balance}{formula}(formula, data, measures = "all", ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.}
}
\value{
A list named by the requested class balance measure.
}
\description{
These measures capture the differences in the number of examples per class in
the dataset. When these differences are severe, problems related to 
generalization of the ML classification techniques could happen because of
the imbalance ratio.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"C1"}{The entropy of class proportions (C1) measure the imbalance in
     a dataset based on the proportions of examples per class.}
   \item{"C2"}{The imbalance ratio (C2) is an index computed for measuring
     class balance. This is a version of the measure that is also suited for 
     multiclass classification problems.}
 }
}
\examples{
## Extract all balance measures
balance(Species ~ ., iris)
}
\references{
Ana C Lorena, Ivan G Costa, Newton Spolaor and Marcilio C P Souto. (2012). 
   Analysis of complexity indices for classification problems: Cancer gene 
   expression data. Neurocomputing 75, 1, 33--42.

 Ajay K Tanwani and Muddassar Farooq. (2010). Classification potential vs. 
   classification accuracy: a comprehensive study of evolutionary algorithms 
   with biomedical datasets. Learning Classifier Systems 6471, 127--144.
}
\seealso{
Other complexity-measures: \code{\link{dimensionality}},
  \code{\link{linearity}}, \code{\link{neighborhood}},
  \code{\link{network}}, \code{\link{overlapping}}
}
