% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVPI.R
\name{create_object_evpi_decrease}
\alias{create_object_evpi_decrease}
\title{Create an object evpi_decrease}
\usage{
create_object_evpi_decrease(object_inmb, object_pop, object_var_inmb,
  step_exp = 1, step_ref = 1)
}
\arguments{
\item{object_inmb}{: an object that represents the INMB (Incremental Net Monetary Benefit)
Create an object with one of these functions : \link{create_object_inmb_direct}, \link{create_object_inmb}}

\item{object_pop}{: an object that represents the size of the targeted population.
Create an object with \link{create_object_pop}}

\item{object_var_inmb}{: an object that represents the variance of INMB. The variance of INMB can be directly hypothesized,
or calculated through sdc, sde, rho and lambda, or calculated through sdc_ref, sde_ref, sdc_exp, sde_exp, rho and lambda.
Create an object with one of these functions : \link{create_object_var_inmb_direct}, \link{create_object_var_inmb},\link{create_object_var_inmb_diff}}

\item{step_exp}{(default=1) : the minimal number of individuals to be included in the experimental group to respect the allocation ratio. If the allocation ratio is 2:1 in favor of the experimental group, step_exp=2 and step_ref=1.}

\item{step_ref}{(default=1) : the minimal number of individuals to be included in the reference group to respect the allocation ratio. If the allocation ratio is 2:1 in favor of the reference group, step_ref=2 and step_exp=1.}
}
\value{
create_object_evpi_decrease returns an object of class \link{EVPI_DECREASE}
}
\description{
An object that combines three others objects : object_inmb, object_pop, object_var_inmb.
It contains methods to compute the value of perfect information (EVPI) that would remain after a study of n participants (EVPIn).
For each additional individual included, the EVPI decreases. So EVPIn is a decreasing vector. It is used to determine the optimal sample size.
}
\examples{
## First, create 3 objects : inmb, pop and var_inmb, then create the evpi_decrease object
object_lambda <- create_object_lambda (20000)
object_inmb <- create_object_inmb(de = 0.04, dc=-168, object_lambda = object_lambda)
object_var_inmb <- create_object_var_inmb(sde=0.12, sdc=2100, rho=0.1, object_lambda=object_lambda)
object_pop <- create_object_pop(horizon = 20, discount=0.04, N_year = 52000)
object_evpi_decrease <- create_object_evpi_decrease(object_inmb, object_pop, object_var_inmb)
}

