% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/executeChecks.R
\name{executeChecksSingleIngredient}
\alias{executeChecksSingleIngredient}
\title{Execute given checks on Drug Exposure for a single ingredient.}
\usage{
executeChecksSingleIngredient(
  cdm,
  ingredient = 1125315,
  subsetToConceptId = NULL,
  checks = c("missing", "exposureDuration", "quantity"),
  minCellCount = 5,
  sampleSize = 10000,
  tablePrefix = NULL,
  earliestStartDate = "2010-01-01",
  verbose = FALSE,
  byConcept = FALSE
)
}
\arguments{
\item{cdm}{CDMConnector reference object}

\item{ingredient}{ingredient, by default: acetaminophen}

\item{subsetToConceptId}{vector of concept IDs of the ingredients
to subset down to. If NULL, all concept IDs for an ingredient will be
considered.}

\item{checks}{the checks to be executed, by default the missing values, the
exposure duration and the quantity.}

\item{minCellCount}{minimum number of events to report- results
lower than this will be obscured. If NULL all results will be reported.}

\item{sampleSize}{the number of samples, default 10.000}

\item{tablePrefix}{The stem for the permanent tables that will
be created when running the diagnostics. Permanent tables will be created using
this prefix, and any existing tables that start with this will be at risk of
being dropped or overwritten. If NULL, temporary tables will be
used throughout.}

\item{earliestStartDate}{the earliest date from which a record can be included}

\item{verbose}{verbose, default FALSE}

\item{byConcept}{boolean argument whether to return restults by Concept or overall only}
}
\value{
named list with results
}
\description{
Execute given checks on Drug Exposure for a single ingredient.
}
