% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tESPlot2DHP.R
\name{tESPlot2DHP}
\alias{tESPlot2DHP}
\title{Plots t ES against holding period}
\usage{
tESPlot2DHP(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily P/L data

 mu Mean of daily P/L data

 sigma Standard deviation of daily P/L data

 df Number of degrees of freedom in the t distribution

 cl ES confidence level and must be a scalar

 hp ES holding period and must be a vector}
}
\description{
Plots the ES of a portfolio against holding period assuming that L/P is t distributed, for specified confidence level and holding periods.
}
\examples{
# Computes ES given geometric return data
   data <- runif(5, min = 0, max = .2)
   tESPlot2DHP(returns = data, df = 6, cl = .95, hp = 60:90)

   # Computes v given mean and standard deviation of return data
   tESPlot2DHP(mu = .012, sigma = .03, df = 6, cl = .99, hp = 40:80)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Evans, M., Hastings, M. and Peacock, B. Statistical Distributions, 3rd
edition, New York: John Wiley, ch. 38,39.
}

