% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVM2gof.R
\name{CVM2gof}
\alias{CVM2gof}
\title{Two-Sample Cramér–von Mises Test (Bootstrap Version)}
\usage{
CVM2gof(
  x,
  y,
  alternative = c("two.sided", "less", "greater"),
  nboots = 2000,
  keep.boots = FALSE
)
}
\arguments{
\item{x}{Numeric vector of observations from the first sample.}

\item{y}{Numeric vector of observations from the second sample.}

\item{alternative}{Character string specifying the alternative hypothesis.
Must be one of \code{"two.sided"} (default), \code{"less"}, or \code{"greater"}.}

\item{nboots}{Number of bootstrap replicates to approximate the null distribution (default: 2000).}

\item{keep.boots}{Logical. If \code{TRUE}, the bootstrap statistics will be returned (default: \code{FALSE}).}
}
\value{
An object of class \code{"htest"} with elements:
\describe{
  \item{statistic}{Observed Cramér–von Mises test statistic.}
  \item{p.value}{Bootstrap-based p-value.}
  \item{alternative}{The alternative hypothesis used.}
  \item{method}{A description of the test.}
  \item{bootstraps}{(Optional) Vector of bootstrap test statistics if \code{keep.boots = TRUE}.}
}
}
\description{
Performs a nonparametric two-sample Cramér–von Mises test using a permutation-based
bootstrap method to assess whether two samples come from the same distribution.
}
\details{
The test compares two empirical cumulative distribution functions (ECDFs).
The bootstrap procedure permutes group labels to generate the null distribution.
Tailored one-sided tests use one-sided squared differences of ECDFs.
}
\examples{
set.seed(123)
x <- rnorm(100, mean = 0, sd = 4)
y <- rnorm(100, mean = 2, sd = 4)
CVM2gof(x, y)

# One-sided test
CVM2gof(x, y, alternative = "greater")

# Store bootstrap replicates
res <- CVM2gof(x, y, keep.boots = TRUE)
hist(res$bootstraps, main = "Bootstrap Distribution", xlab = "Test Statistic")

}
