% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADgof.R
\name{ADgof}
\alias{ADgof}
\title{Anderson-Darling Goodness-of-Fit Test for a Specified Distribution}
\usage{
ADgof(
  x,
  dist = c("norm", "exp", "unif", "lnorm", "weibull", "gamma", "t", "chisq"),
  ...,
  eps = 1e-15
)
}
\arguments{
\item{x}{A numeric vector of sample observations.}

\item{dist}{A character string specifying the null distribution. Options are
\code{"norm"}, \code{"exp"}, \code{"unif"}, \code{"lnorm"}, \code{"weibull"},
\code{"gamma"}, \code{"t"}, and \code{"chisq"}.}

\item{...}{Additional named parameters passed to the corresponding distribution functions
(e.g., \code{mean}, \code{sd}, \code{rate}, \code{df}, etc.).}

\item{eps}{A small positive constant to avoid log(0) during computation (default: \code{1e-15}).}
}
\value{
A list of class \code{"htest"} with components:
\describe{
  \item{statistic}{The value of the Anderson-Darling test statistic.}
  \item{p.value}{The approximate p-value computed using adjustment formulas.}
  \item{method}{A description of the test performed.}
  \item{data.name}{The name of the input data.}
}
}
\description{
Performs the Anderson-Darling (AD) goodness-of-fit test for a given univariate distribution.
The function computes the AD statistic and returns an approximate p-value based on adjusted formulas.
}
\details{
This implementation supports several common distributions. Parameters of the null distribution
must be supplied via \code{...}. The p-value is calculated using the approximations suggested
by Stephens (1986) and other refinements. For small samples or custom distributions, a bootstrap
version may be preferred.
}
\examples{
set.seed(123)
x1 <- rnorm(500, mean = 5, sd = 2)
ADgof(x1, dist = "norm", mean = 5, sd = 2)

x2 <- rexp(400, rate = 1.5)
ADgof(x2, dist = "exp")
ADgof(x2, dist = "exp", rate = 1.5)

x3 <- runif(300, min = -2, max = 4)
ADgof(x3, dist = "unif", min = -2, max = 4)
}
