% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logarithmic.R
\name{Logarithmic}
\alias{Logarithmic}
\alias{dLogarithmic}
\alias{pLogarithmic}
\alias{expValLogarithmic}
\alias{varLogarithmic}
\alias{VatRLogarithmic}
\alias{mgfLogarithmic}
\alias{pgfLogarithmic}
\title{Logarithmic Distribution}
\usage{
dLogarithmic(x, prob)

pLogarithmic(q, prob, lower.tail = TRUE)

expValLogarithmic(prob)

varLogarithmic(prob)

VatRLogarithmic(kap, prob)

mgfLogarithmic(t, prob)

pgfLogarithmic(t, prob)
}
\arguments{
\item{x}{vector of quantiles.}

\item{prob}{probability parameter \eqn{\gamma}{gamma}.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{dLogarithmic}}}{ gives the probability density function (PDF).}
    \item{\code{\link{pLogarithmic}}}{ gives the cumulative density function (CDF).}
    \item{\code{\link{expValLogarithmic}}}{ gives the expected value.}
    \item{\code{\link{varLogarithmic}}}{ gives the variance.}
    \item{\code{\link{VatRLogarithmic}}}{ gives the Value-at-Risk.}
    \item{\code{\link{mgfLogarithmic}}}{ gives the moment generating function (MGF).}
    \item{\code{\link{pgfLogarithmic}}}{ gives the probability generating function (MGF).}
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Logarithmic distribution with probability parameter \eqn{\gamma}{gamma}.
}
\details{
The Logarithmic distribution with probability parameter \eqn{\gamma}{gam}
has probability mass function :
  \deqn{Pr(X = k) = \frac{-\gamma^{k}}{\ln(1 - \gamma)k}}{-gam^k / (ln(1 - k) k)},
for \eqn{k = 0, 1, 2, \dots}{k = 0, 1, 2, ...},
and \eqn{\gamma  \in (0, 1)}{0 < gam < 1}].
}
\examples{
dLogarithmic(x = 3, prob = 0.2)

pLogarithmic(q = 3, prob = 0.2)

expValLogarithmic(prob = 0.50)

varLogarithmic(prob = 0.50)

VatRLogarithmic(kap = 0.99, prob = 0.2)

mgfLogarithmic(t = .2, prob = 0.50)

pgfLogarithmic(t = .2, prob = 0.50)

}
