% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VaR_llogis.R
\name{VaR_llogis}
\alias{VaR_llogis}
\title{Value-at-Risk of the Loglogistic distribution}
\usage{
VaR_llogis(kap, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{kap}{probability.}

\item{shape}{shape parameter \eqn{\tau}{tau}, must be positive integer.}

\item{rate}{alternative parameterization the scale parameter, rate = 1 / scale.}

\item{scale}{\eqn{\lambda}{lambda} rate parameter, must be positive.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{E_llogis}}}{ gives the expected value.}
 \item{\code{\link{V_llogis}}}{ gives the variance.}
 \item{\code{\link{kthmoment_llogis}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_llogis}}}{ gives the truncated mean.}
 \item{\code{\link{SL_llogis}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_llogis}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_llogis}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_llogis}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_llogis}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Value-at-Risk of the Loglogistic distribution with shape
 parameter \eqn{\tau}{tau} and scale parameter \eqn{\lambda}{lambda}.
}
\details{
The Loglogistic distribution with shape parameter \eqn{\tau}{t} and scale parameter
  \eqn{\lambda}{lam} has density:
  \deqn{\frac{\tau \lambda^\tau x^{\tau -1}}{(\lambda^{\tau }+x^{\tau })^{2}}}{f(x) = t lam^t x^(t - 1) / (lam^t + x^t)^2}
  for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\lambda, \tau > 0}{lam, t > 0}.
}
\examples{

# With scale parameter
VaR_llogis(kap = 0.8, shape = 3, scale = 5)

# With rate parameter
VaR_llogis(kap = 0.8, shape = 3, rate = 0.2)

}
\seealso{
Other Loglogistic Distribution: 
\code{\link{E_llogis}()},
\code{\link{Elim_llogis}()},
\code{\link{Etronq_llogis}()},
\code{\link{Mexcess_llogis}()},
\code{\link{SL_llogis}()},
\code{\link{TVaR_llogis}()},
\code{\link{V_llogis}()},
\code{\link{kthmoment_llogis}()}
}
\concept{Loglogistic Distribution}
