% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Etronq_exp.R
\name{Etronq_exp}
\alias{Etronq_exp}
\title{Truncated mean of the Exponential distribution}
\usage{
Etronq_exp(d, rate = 1/scale, scale = 1/rate, less.than.d = TRUE)
}
\arguments{
\item{d}{cut-off value.}

\item{rate}{\eqn{\beta}{beta} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_exp}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_exp}}}{ gives the expected value.}
 \item{\code{\link{V_exp}}}{ gives the variance.}
 \item{\code{\link{kthmoment_exp}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_exp}}}{ gives the truncated mean.}
 \item{\code{\link{SL_exp}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_exp}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_exp}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_exp}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_exp}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Truncated mean of the Exponential distribution with
 rate parameter \eqn{\beta}{beta}.
}
\details{
The Exponential distribution with rate parameter \eqn{\beta}{b} has %
  density: \deqn{f\left(x\right) = \frac{1}{\beta}%
  \textrm{e}^{-\beta x}}{f(x) = b^a e^{-b x}} for %
  \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta > 0}{b > 0}.
}
\examples{

# With scale parameter
Etronq_exp(d = 2, scale = 4)

# With rate parameter
Etronq_exp(d = 2, rate = 0.25, less.than.d = FALSE)

}
\seealso{
Other Exponential Distribution: 
\code{\link{E_exp}()},
\code{\link{Elim_exp}()},
\code{\link{MGF_exp}()},
\code{\link{Mexcess_exp}()},
\code{\link{SL_exp}()},
\code{\link{TVaR_exp}()},
\code{\link{V_exp}()},
\code{\link{VaR_exp}()},
\code{\link{kthmoment_exp}()}
}
\concept{Exponential Distribution}
