% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disequilibrium.R
\name{DlhoodDlogsigma11}
\alias{DlhoodDlogsigma11}
\title{Derivative of likelihood with respect to the log of variance for equation 1}
\usage{
DlhoodDlogsigma11(Y, mu, logsigma11, logsigma22, atanhrho)
}
\arguments{
\item{Y}{A vector of observed responses.}

\item{mu}{A \eqn{N \times 2}{N x 2} matrix of means for equations 1 and 2.}

\item{logsigma11}{A scalar log of the variance of the equation 1.}

\item{logsigma22}{A scalar log of the variance of the equation 2.}

\item{atanhrho}{A scalar of the inverse hyperbolic tangent of the correlation of equations 1 and 2.}
}
\value{
A vector of derivatives for each observation.
}
\description{
Derivative of likelihood with respect to the log of variance for equation 1
}
\examples{
set.seed(1775)
library(MASS)
beta01 = c(1,1)
beta02 = c(-1,-1)
N = 10000
SigmaEps = diag(2)
SigmaX = diag(2)
MuX = c(0,0)
par0 = c(beta01, beta02, SigmaX[1, 1], SigmaX[1, 2], SigmaX[2, 2])

Xgen = mvrnorm(N,MuX,SigmaX)
X1 = cbind(1,Xgen[,1])
X2 = cbind(1,Xgen[,2])
X = list(X1 = X1,X2 = X2)
eps = mvrnorm(N,c(0,0),SigmaEps)
eps1 = eps[,1]
eps2 = eps[,2]
Y1 = X1 \%*\% beta01 + eps1
Y2 = X2 \%*\% beta02 + eps2
Y = pmin(Y1,Y2)

p1 = 2
p2 = 2
theta = c(beta01, beta02, log(SigmaX[1, 1]), atanh(SigmaX[1, 2]), log(SigmaX[2, 2]))
mu = cbind(X[[1]] \%*\% theta[1:p1], X[[2]] \%*\% theta[(p1 + 1):(p1 + p2)])

d = DlhoodDlogsigma11(Y = Y, mu = mu, logsigma11 = theta[p1 + p2 + 1],
   logsigma22 = theta[p1 + p2 + 3], atanhrho = theta[p1 + p2 + 2])
head(d)

}
