% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBR_fun.R
\name{DBR}
\alias{DBR}
\title{[DBR-lambda] procedure}
\usage{
DBR(pCDFlist, raw.pvalues, alpha = 0.05, lambda = 0.05,
  ret.crit.consts = FALSE, bigMem = FALSE, verbose = FALSE)
}
\arguments{
\item{pCDFlist}{a list of the supports of the CDFs of the p-values. Each support is represented by a vector that must be in increasing order.}

\item{raw.pvalues}{vector of the raw observed p-values, as provided by the end user and before matching with their nearest neighbour in the CDFs supports.}

\item{alpha}{the target FDR level, a number strictly between 0 and 1.}

\item{lambda}{a number strictly between 0 and 1.}

\item{ret.crit.consts}{a boolean. If \code{TRUE}, critical constants are computed and returned (this is computationally intensive).}

\item{bigMem}{a boolean. If \code{TRUE}, the code uses matrixes and functions of the apply family as far as possible (faster for small number of hypotheses and support size, but slower otherwise due to memory management overhead). If \code{FALSE}, computations are done with \code{for} loops and chunks to conserve memory.}

\item{verbose}{a boolean indicating if \code{msg} must be printed. Used when \code{bigMem=TRUE}, to print messages informing if in-memory computation was successful or if loops and chunks were used as fallback.}
}
\value{
A list whose elements are:
\item{Rejected}{rejected raw p-values}
\item{Indices}{indices of rejected hypotheses}
\item{Max.k}{number of rejections}
\item{Alpha}{maximum significance level for which a rejection occured, that is \eqn{Alpha = alpha * Max.k / m}}
\item{Critical.constants}{critical constants (if requested)}
\item{Adjusted}{adjusted p-values }
\item{Lambda}{value of \code{lambda}.}
}
\description{
Apply the [DBR-lambda] procedure,
with or without computing the critical constants,
to a set of p-values and their discrete support.
}
\details{
This version: 2018-02-19.
}
\examples{
data(amnesia)

#We only keep the first 100 lines to keep the computations fast.
amnesia<-amnesia[1:100,]

#Construction of the p-values and their support
amnesia.formatted <- fisher.pvalues.support(amnesia)
raw.pvalues <- amnesia.formatted$raw
pCDFlist <- amnesia.formatted$support

DBR.su.fast <- DBR(pCDFlist, raw.pvalues)
DBR.su.crit <- DBR(pCDFlist, raw.pvalues, ret.crit.consts=TRUE)

}
