#' @title Data for Diallel Analysis using Griffing Approach Method 1
#' @name   GriffingData1
#' @docType data
#' @keywords datasets
#' @usage data(GriffingData1)
#' @description \code{Griffing} is used for performing Diallel Analysis using Griffing's Approach.
#' @format A \code{data.frame} with 256 rows and 4 variables.
#' @details
#'        \itemize{
#'        \item Cross1 Cross 1
#'        \item Cross2 Cross 2
#'        \item Rep Replicate
#'        \item Yield Yield Response
#'        }
#' @author Muhammad Yaseen (\email{myaseen208@@gmail.com})
#' @references \enumerate{
#' \item Griffing, B. (1956) Concept of General and Specific Combining Ability
#'             in relation to Diallel Crossing Systems. \emph{Australian Journal of Biological Sciences},
#'              \strong{9(4)}, 463--493.
#' \item Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
#'              New Delhi: Kalyani.
#'  }
#' @seealso 
#'    \code{\link{Griffing}}
#'  , \code{\link{GriffingData2}}
#'  , \code{\link{GriffingData3}}
#'  , \code{\link{GriffingData4}}
#' @examples
#' data(GriffingData1)
NULL
